/*
 * Decompiled with CFR 0.152.
 */
package io.uok.spacex.core.service.impl;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.querydsl.core.QueryResults;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import io.uok.spacex.core.dao.DictionaryDAO;
import io.uok.spacex.core.dao.DictionaryItemDAO;
import io.uok.spacex.core.domain.DictionaryDO;
import io.uok.spacex.core.domain.DictionaryItemDO;
import io.uok.spacex.core.domain.QDictionaryDO;
import io.uok.spacex.core.domain.QDictionaryItemDO;
import io.uok.spacex.core.dto.DictItemDTO;
import io.uok.spacex.core.service.DictionarySV;
import io.uok.spacex.exception.BusinessException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;

public class DictionarySVImpl
implements DictionarySV {
    @Resource
    private DictionaryDAO dictionaryDAO;
    @Resource
    private DictionaryItemDAO dictionaryItemDAO;
    @Resource
    private JPAQueryFactory jpaQueryFactory;

    @Override
    public void add(DictionaryDO dictionary) {
        QDictionaryDO qDictionary = QDictionaryDO.dictionaryDO;
        boolean exists = this.dictionaryDAO.exists((Predicate)qDictionary.code.eq((Object)dictionary.getCode()));
        if (exists) {
            throw new BusinessException("\u5b57\u5178\u7f16\u7801\u5df2\u7ecf\u5b58\u5728\uff0c\u6dfb\u52a0\u5931\u8d25.");
        }
        this.dictionaryDAO.save(dictionary);
    }

    @Override
    public void update(DictionaryDO dictionary) {
        QDictionaryDO qDictionary = QDictionaryDO.dictionaryDO;
        BooleanExpression predicate = qDictionary.code.eq((Object)dictionary.getCode()).and((Predicate)qDictionary.id.ne((Object)dictionary.getId()));
        boolean exists = this.dictionaryDAO.exists((Predicate)predicate);
        if (exists) {
            throw new BusinessException("\u5b57\u5178\u7f16\u7801\u5df2\u7ecf\u5b58\u5728\uff0c\u4fee\u6539\u5931\u8d25.");
        }
        this.dictionaryDAO.save(dictionary);
    }

    @Override
    public DictionaryDO get(String code) {
        return this.dictionaryDAO.findByCode(code);
    }

    @Override
    public void delete(Long id) {
        this.dictionaryDAO.deleteById(id);
    }

    @Override
    public Page<DictionaryDO> find(String name, String code, String description, Pageable pageable) {
        QDictionaryDO qDictionary = QDictionaryDO.dictionaryDO;
        ArrayList predicates = Lists.newArrayList();
        if (!Strings.isNullOrEmpty((String)name)) {
            predicates.add(qDictionary.name.like(name));
        }
        if (!Strings.isNullOrEmpty((String)code)) {
            predicates.add(qDictionary.code.eq((Object)code));
        }
        if (!Strings.isNullOrEmpty((String)description)) {
            predicates.add(qDictionary.description.like(description));
        }
        return this.dictionaryDAO.findAll(ExpressionUtils.allOf((Collection)predicates), pageable);
    }

    @Override
    public List<DictItemDTO> getItems(String code) {
        QDictionaryDO qDictionary = QDictionaryDO.dictionaryDO;
        QDictionaryItemDO qDictionaryItem = QDictionaryItemDO.dictionaryItemDO;
        QueryResults results = ((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(DictItemDTO.class, (Expression[])new Expression[]{qDictionary.code, qDictionaryItem.label, qDictionaryItem.value})).from((EntityPath)qDictionary)).leftJoin((EntityPath)qDictionaryItem)).on((Predicate)qDictionary.id.eq(qDictionaryItem.dictionaryId))).where((Predicate)qDictionary.code.eq((Object)code))).where((Predicate)qDictionaryItem.status.eq((Object)1))).fetchResults();
        return results.getResults();
    }

    @Override
    public void addItem(DictionaryItemDO dictionaryItem) {
        QDictionaryItemDO qDictionaryItem = QDictionaryItemDO.dictionaryItemDO;
        boolean exists = this.dictionaryItemDAO.exists((Predicate)qDictionaryItem.dictionaryId.eq((Object)dictionaryItem.getDictionaryId()).and((Predicate)qDictionaryItem.label.eq((Object)dictionaryItem.getLabel()).or((Predicate)qDictionaryItem.value.eq((Object)dictionaryItem.getValue()))));
        if (exists) {
            throw new BusinessException("\u5b57\u5178\u9879\u503c\u6216\u8005\u6587\u672c\u5b58\u5728\u91cd\u590d\uff0c\u6dfb\u52a0\u5931\u8d25.");
        }
        this.dictionaryItemDAO.save(dictionaryItem);
    }

    @Override
    public void updateItem(DictionaryItemDO dictionaryItem) {
        QDictionaryItemDO qDictionaryItem = QDictionaryItemDO.dictionaryItemDO;
        boolean exists = this.dictionaryItemDAO.exists((Predicate)qDictionaryItem.id.ne((Object)dictionaryItem.getId()).and((Predicate)qDictionaryItem.dictionaryId.eq((Object)dictionaryItem.getDictionaryId())).and((Predicate)qDictionaryItem.label.eq((Object)dictionaryItem.getLabel()).or((Predicate)qDictionaryItem.value.eq((Object)dictionaryItem.getValue()))));
        if (exists) {
            throw new BusinessException("\u5b57\u5178\u9879\u503c\u6216\u8005\u6587\u672c\u5b58\u5728\u91cd\u590d\uff0c\u6dfb\u52a0\u5931\u8d25.");
        }
        this.dictionaryItemDAO.save(dictionaryItem);
    }

    @Override
    public void deleteItem(Long itemId) {
        this.dictionaryItemDAO.deleteById(itemId);
    }

    @Override
    public List<DictionaryItemDO> findItems(Long id) {
        QDictionaryItemDO qDictionaryItem = QDictionaryItemDO.dictionaryItemDO;
        return Lists.newArrayList((Iterable)this.dictionaryItemDAO.findAll((Predicate)qDictionaryItem.dictionaryId.eq((Object)id)));
    }
}

