/*
 * Decompiled with CFR 0.152.
 */
package io.uok.spacex.validator;

import com.google.common.base.Objects;
import com.google.common.collect.Iterators;
import io.uok.spacex.core.SpringContextHolder;
import io.uok.spacex.core.dto.DictItemDTO;
import io.uok.spacex.core.service.DictionarySV;
import io.uok.spacex.validator.constraints.Dict;
import java.util.List;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import org.springframework.util.CollectionUtils;

public class DictValidator
implements ConstraintValidator<Dict, String> {
    private String name;

    public void initialize(Dict dict) {
        this.name = dict.name();
    }

    public boolean isValid(String value, ConstraintValidatorContext context) {
        if (null == value) {
            return true;
        }
        DictionarySV dictionaryService = SpringContextHolder.getBean(DictionarySV.class);
        List<DictItemDTO> dictItems = dictionaryService.getItems(this.name);
        if (!CollectionUtils.isEmpty(dictItems)) {
            return Iterators.any(dictItems.iterator(), item -> Objects.equal((Object)item.getValue(), (Object)value));
        }
        return false;
    }
}

