package io.uok.spacex.redis.serializer;

import io.uok.spacex.util.KryoUtils;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.data.redis.serializer.SerializationException;

/**
 * Kryo redis 序列化和反序列化
 */
public class KryoRedisSerializer<T> implements RedisSerializer<T> {

  public byte[] serialize(T t) throws SerializationException {
    return KryoUtils.writeToByteArray(t);
  }

  public T deserialize(byte[] bytes) throws SerializationException {
    return KryoUtils.readFromByteArray(bytes);
  }
}
