/*
 * Decompiled with CFR 0.152.
 */
package io.uok.spacex.redis;

import com.google.common.base.Splitter;
import java.util.List;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.data.redis.RedisAutoConfiguration;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.redis.connection.RedisClusterConfiguration;
import org.springframework.data.redis.connection.RedisPassword;
import org.springframework.data.redis.connection.RedisStandaloneConfiguration;
import org.springframework.data.redis.connection.lettuce.LettuceConnectionFactory;

@Configuration
@ConfigurationProperties(prefix="spacex.redis")
@ConditionalOnProperty(name={"spacex.redis.enable"}, havingValue="true", matchIfMissing=true)
@AutoConfigureBefore(value={RedisAutoConfiguration.class})
public class RedisConfig {
    @Value(value="${spacex.redis.servers}")
    private String servers;
    @Value(value="${spacex.redis.password:}")
    private String password;
    private static final Splitter serverSplitter = Splitter.on((char)',').trimResults();
    private static final Splitter splitter = Splitter.on((char)':');

    @Bean
    public LettuceConnectionFactory redisConnectionFactory() {
        List serverList = serverSplitter.splitToList((CharSequence)this.servers);
        if (1 < serverList.size()) {
            RedisClusterConfiguration config = new RedisClusterConfiguration();
            for (String server : serverList) {
                List hostPort = splitter.splitToList((CharSequence)server);
                config.clusterNode((String)hostPort.get(0), Integer.valueOf(Integer.parseInt((String)hostPort.get(1))));
            }
            config.setMaxRedirects(3);
            if (this.password != null) {
                config.setPassword(RedisPassword.of((String)this.password));
            }
            return new LettuceConnectionFactory(config);
        }
        List hostPort = splitter.splitToList((CharSequence)serverList.get(0));
        RedisStandaloneConfiguration config = new RedisStandaloneConfiguration();
        config.setHostName((String)hostPort.get(0));
        config.setPort(Integer.parseInt((String)hostPort.get(1)));
        if (this.password != null) {
            config.setPassword(RedisPassword.of((String)this.password));
        }
        config.setDatabase(0);
        return new LettuceConnectionFactory(config);
    }
}

