package io.uok.spacex.task;

import org.quartz.DisallowConcurrentExecution;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.PersistJobDataAfterExecution;
import org.springframework.context.ApplicationContext;
import org.springframework.scheduling.quartz.QuartzJobBean;

@DisallowConcurrentExecution
@PersistJobDataAfterExecution
public class SpaceXQuartzJobBean extends QuartzJobBean {

  @Override
  protected void executeInternal(JobExecutionContext context) throws JobExecutionException {
    String jobName = context.getMergedJobDataMap().getString("_jobName");
    Class<Job> jobClazz = (Class<Job>) context.getMergedJobDataMap().get("_jobTargetClazz");
    ApplicationContext applicationContext = SpaceXJobAnnotationBeanPostProcessor.applicationContext;
    JobContext jobContext = new JobContext(jobName, context.getFireInstanceId(),
        context.getMergedJobDataMap().getWrappedMap());
    applicationContext.getBean(jobClazz).execute(jobContext);
  }
}
