/*
 * Decompiled with CFR 0.152.
 */
package io.uok.spacex.task;

import io.uok.spacex.task.Job;
import io.uok.spacex.task.SpaceXQuartzJobBean;
import io.uok.spacex.task.annotation.ScheduledJob;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javax.sql.DataSource;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationListener;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.scheduling.quartz.CronTriggerFactoryBean;
import org.springframework.scheduling.quartz.JobDetailFactoryBean;
import org.springframework.scheduling.quartz.SchedulerFactoryBean;
import org.springframework.transaction.PlatformTransactionManager;

public class SpaceXJobAnnotationBeanPostProcessor
implements BeanPostProcessor,
ApplicationContextAware,
ApplicationListener<ContextRefreshedEvent>,
DisposableBean {
    protected static ConfigurableApplicationContext applicationContext;
    private DefaultListableBeanFactory defaultListableBeanFactory;
    private List<Trigger> triggers = new ArrayList<Trigger>();
    private String instanceName;
    private Boolean cluster;

    public SpaceXJobAnnotationBeanPostProcessor(String instanceName, Boolean cluster) {
        this.instanceName = instanceName;
        this.cluster = cluster;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        SpaceXJobAnnotationBeanPostProcessor.applicationContext = (ConfigurableApplicationContext)applicationContext;
        this.defaultListableBeanFactory = (DefaultListableBeanFactory)SpaceXJobAnnotationBeanPostProcessor.applicationContext.getBeanFactory();
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        if (!(bean instanceof Job)) {
            return bean;
        }
        ScheduledJob scheduledJob = bean.getClass().getAnnotation(ScheduledJob.class);
        if (scheduledJob == null) {
            return bean;
        }
        String jobBeanName = beanName + "JobDetail";
        BeanDefinitionBuilder jobDetailBuilder = BeanDefinitionBuilder.genericBeanDefinition(JobDetailFactoryBean.class);
        String jobName = "".equals(scheduledJob.name()) ? beanName : scheduledJob.name();
        jobDetailBuilder.addPropertyValue("name", (Object)jobName);
        jobDetailBuilder.addPropertyValue("jobClass", SpaceXQuartzJobBean.class);
        JobDataMap jobDataMap = new JobDataMap();
        jobDataMap.put("_jobName", jobName);
        jobDataMap.put("_jobTargetClazz", bean.getClass());
        jobDetailBuilder.addPropertyValue("jobDataMap", (Object)jobDataMap);
        jobDetailBuilder.addPropertyValue("durability", (Object)true);
        jobDetailBuilder.addPropertyValue("description", (Object)bean.getClass().getName());
        jobDetailBuilder.addPropertyValue("beanName", (Object)jobBeanName);
        this.defaultListableBeanFactory.registerBeanDefinition(jobBeanName, (BeanDefinition)jobDetailBuilder.getBeanDefinition());
        String triggerBeanName = beanName + "Trigger";
        BeanDefinitionBuilder triggerBuilder = BeanDefinitionBuilder.genericBeanDefinition(CronTriggerFactoryBean.class);
        JobDetail jobDetail = (JobDetail)applicationContext.getBean(jobBeanName, JobDetail.class);
        triggerBuilder.addPropertyValue("jobDetail", (Object)jobDetail);
        triggerBuilder.addPropertyValue("description", (Object)bean.getClass().getName());
        triggerBuilder.addPropertyValue("cronExpression", (Object)scheduledJob.cron());
        this.defaultListableBeanFactory.registerBeanDefinition(triggerBeanName, (BeanDefinition)triggerBuilder.getBeanDefinition());
        this.triggers.add((Trigger)applicationContext.getBean(triggerBeanName, Trigger.class));
        return bean;
    }

    private void finishRegistration() {
        if (!this.triggers.isEmpty()) {
            BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition(SchedulerFactoryBean.class);
            ThreadPoolTaskExecutor taskExecutor = (ThreadPoolTaskExecutor)this.defaultListableBeanFactory.getBean(ThreadPoolTaskExecutor.class);
            if (taskExecutor != null) {
                builder.addPropertyValue("taskExecutor", (Object)taskExecutor);
            }
            if (this.cluster.booleanValue()) {
                DataSource dataSource = (DataSource)this.defaultListableBeanFactory.getBean(DataSource.class);
                builder.addPropertyValue("dataSource", (Object)dataSource);
                PlatformTransactionManager txManager = (PlatformTransactionManager)this.defaultListableBeanFactory.getBean(PlatformTransactionManager.class);
                if (txManager != null) {
                    builder.addPropertyValue("transactionManager", (Object)txManager);
                }
            }
            builder.addPropertyValue("triggers", (Object)this.triggers.toArray());
            builder.addPropertyValue("quartzProperties", (Object)this.quartzProperties());
            String beanName = "schedulerFactoryBean";
            this.defaultListableBeanFactory.registerBeanDefinition(beanName, (BeanDefinition)builder.getBeanDefinition());
            try {
                ((Scheduler)applicationContext.getBean(beanName, Scheduler.class)).start();
            }
            catch (SchedulerException | BeansException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public void destroy() throws Exception {
    }

    public void onApplicationEvent(ContextRefreshedEvent contextRefreshedEvent) {
        if (contextRefreshedEvent.getApplicationContext() == applicationContext) {
            this.finishRegistration();
        }
    }

    private Properties quartzProperties() {
        Properties prop = new Properties();
        prop.put("quartz.scheduler.instanceName", this.instanceName);
        prop.put("org.quartz.scheduler.instanceId", "AUTO");
        prop.put("org.quartz.scheduler.skipUpdateCheck", "true");
        if (this.cluster.booleanValue()) {
            prop.put("org.quartz.jobStore.class", "org.quartz.impl.jdbcjobstore.JobStoreTX");
            prop.put("org.quartz.jobStore.driverDelegateClass", "org.quartz.impl.jdbcjobstore.StdJDBCDelegate");
            prop.put("org.quartz.jobStore.isClustered", "true");
            prop.put("org.quartz.jobStore.useProperties", "false");
            prop.put("org.quartz.jobStore.clusterCheckinInterval", "5000");
            prop.put("org.quartz.jobStore.maxMisfiresToHandleAtATime", "1");
            prop.put("org.quartz.jobStore.misfireThreshold", "120000");
            prop.put("org.quartz.jobStore.acquireTriggersWithinLock", "true");
        }
        prop.put("org.quartz.plugin.shutdownhook.class", "org.quartz.plugins.management.ShutdownHookPlugin");
        prop.put("org.quartz.plugin.shutdownhook.cleanShutdown", "true");
        return prop;
    }
}

