/*
 * Decompiled with CFR 0.152.
 */
package io.uok.spacex.task;

import io.uok.spacex.task.SpaceXJobAnnotationBeanPostProcessor;
import io.uok.spacex.task.service.TaskSV;
import io.uok.spacex.task.service.impl.TaskSVImpl;
import javax.annotation.Resource;
import javax.sql.DataSource;
import org.quartz.Scheduler;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.AbstractDependsOnBeanFactoryPostProcessor;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnSingleCandidate;
import org.springframework.boot.autoconfigure.quartz.QuartzDataSource;
import org.springframework.boot.autoconfigure.quartz.QuartzDataSourceInitializer;
import org.springframework.boot.autoconfigure.quartz.QuartzProperties;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.io.ResourceLoader;
import org.springframework.scheduling.quartz.SchedulerFactoryBean;

@Configuration
@ConfigurationProperties(prefix="spacex.task")
@ConditionalOnProperty(name={"spacex.task.enable"}, havingValue="true", matchIfMissing=true)
@EnableConfigurationProperties(value={QuartzProperties.class})
public class TaskConfig {
    @Value(value="${spacex.task.instance-name:${spring.application.name}}")
    private String instanceName;
    @Value(value="${spacex.task.cluster: true}")
    private Boolean cluster;

    @Bean
    public SpaceXJobAnnotationBeanPostProcessor spaceXJobAnnotationBeanPostProcessor() {
        return new SpaceXJobAnnotationBeanPostProcessor(this.instanceName, this.cluster);
    }

    @Bean
    public TaskSV taskSV() {
        return new TaskSVImpl();
    }

    @Configuration
    @ConditionalOnSingleCandidate(value=DataSource.class)
    @ConditionalOnProperty(name={"spacex.task.cluster"}, havingValue="true", matchIfMissing=true)
    protected static class JdbcStoreTypeConfiguration {
        protected JdbcStoreTypeConfiguration() {
        }

        private DataSource getDataSource(DataSource dataSource, ObjectProvider<DataSource> quartzDataSource) {
            DataSource dataSourceIfAvailable = (DataSource)quartzDataSource.getIfAvailable();
            return dataSourceIfAvailable != null ? dataSourceIfAvailable : dataSource;
        }

        @Bean
        @ConditionalOnMissingBean
        @Resource
        public QuartzDataSourceInitializer quartzDataSourceInitializer(DataSource dataSource, @QuartzDataSource ObjectProvider<DataSource> quartzDataSource, ResourceLoader resourceLoader, QuartzProperties properties) {
            DataSource dataSourceToUse = this.getDataSource(dataSource, quartzDataSource);
            return new QuartzDataSourceInitializer(dataSourceToUse, resourceLoader, properties);
        }

        @Bean
        public static DataSourceInitializerSchedulerDependencyPostProcessor dataSourceInitializerSchedulerDependencyPostProcessor() {
            return new DataSourceInitializerSchedulerDependencyPostProcessor();
        }

        private static class DataSourceInitializerSchedulerDependencyPostProcessor
        extends AbstractDependsOnBeanFactoryPostProcessor {
            DataSourceInitializerSchedulerDependencyPostProcessor() {
                super(Scheduler.class, SchedulerFactoryBean.class, new String[]{"quartzDataSourceInitializer"});
            }
        }
    }
}

