/*
 * Decompiled with CFR 0.152.
 */
package io.uok.spacex.task.service.impl;

import com.google.common.collect.Lists;
import io.uok.spacex.exception.SystemException;
import io.uok.spacex.task.JobState;
import io.uok.spacex.task.dto.JobDTO;
import io.uok.spacex.task.service.TaskSV;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.annotation.Resource;
import org.quartz.CronExpression;
import org.quartz.CronScheduleBuilder;
import org.quartz.CronTrigger;
import org.quartz.JobDetail;
import org.quartz.JobExecutionContext;
import org.quartz.JobKey;
import org.quartz.ScheduleBuilder;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.impl.matchers.GroupMatcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Lazy;
import org.springframework.util.CollectionUtils;

public class TaskSVImpl
implements TaskSV {
    private static final Logger log = LoggerFactory.getLogger(TaskSVImpl.class);
    @Resource
    @Lazy
    private Scheduler scheduler;

    @Override
    public List<JobDTO> getAllJobs() {
        try {
            ArrayList jobs = Lists.newArrayList();
            List groups = this.scheduler.getJobGroupNames();
            if (CollectionUtils.isEmpty((Collection)groups)) {
                return null;
            }
            for (String group : groups) {
                Set jobKeys = this.scheduler.getJobKeys(GroupMatcher.jobGroupEquals((String)group));
                for (JobKey jobKey : jobKeys) {
                    JobDetail jobDetail = this.scheduler.getJobDetail(jobKey);
                    List triggers = this.scheduler.getTriggersOfJob(jobKey);
                    if (CollectionUtils.isEmpty((Collection)triggers)) continue;
                    for (CronTrigger trigger : triggers) {
                        JobDTO jobDTO = this.newJobDTO(jobDetail, trigger);
                        jobs.add(jobDTO);
                    }
                }
            }
            return jobs;
        }
        catch (SchedulerException e) {
            log.error("\u83b7\u53d6\u5168\u90e8\u4efb\u52a1\u5931\u8d25", (Throwable)e);
            throw new SystemException("\u83b7\u53d6\u5168\u90e8\u4efb\u52a1\u5931\u8d25");
        }
    }

    private JobDTO newJobDTO(JobDetail jobDetail, CronTrigger trigger) throws SchedulerException {
        JobDTO jobDTO = new JobDTO();
        jobDTO.setName(jobDetail.getKey().getName());
        jobDTO.setClazz(jobDetail.getDescription());
        jobDTO.setCron(trigger.getCronExpression());
        jobDTO.setState(JobState.valueOf(this.scheduler.getTriggerState(trigger.getKey()).name()));
        jobDTO.setPreviousFireTime(trigger.getPreviousFireTime());
        jobDTO.setNextFireTime(trigger.getNextFireTime());
        return jobDTO;
    }

    @Override
    public List<JobDTO> getExecutingJobs() {
        try {
            ArrayList jobs = Lists.newArrayList();
            List jobExecutionContexts = this.scheduler.getCurrentlyExecutingJobs();
            if (CollectionUtils.isEmpty((Collection)jobExecutionContexts)) {
                return null;
            }
            for (JobExecutionContext jobExecutionContext : jobExecutionContexts) {
                JobDTO jobDTO = this.newJobDTO(jobExecutionContext.getJobDetail(), (CronTrigger)jobExecutionContext.getTrigger());
                jobs.add(jobDTO);
            }
            return jobs;
        }
        catch (SchedulerException e) {
            log.error("\u83b7\u53d6\u5168\u90e8\u4efb\u52a1\u5931\u8d25", (Throwable)e);
            throw new SystemException("\u83b7\u53d6\u5168\u90e8\u4efb\u52a1\u5931\u8d25");
        }
    }

    @Override
    public void pauseAllJobs() {
        try {
            this.scheduler.pauseAll();
        }
        catch (SchedulerException e) {
            log.error("\u6682\u505c\u5168\u90e8\u4efb\u52a1\u5931\u8d25", (Throwable)e);
            throw new SystemException("\u6682\u505c\u5168\u90e8\u4efb\u52a1\u5931\u8d25");
        }
    }

    @Override
    public void resumeAllJobs() {
        try {
            this.scheduler.resumeAll();
        }
        catch (SchedulerException e) {
            log.error("\u6062\u590d\u5168\u90e8\u4efb\u52a1\u5931\u8d25", (Throwable)e);
            throw new SystemException("\u6062\u590d\u5168\u90e8\u4efb\u52a1\u5931\u8d25");
        }
    }

    @Override
    public void pauseJob(String jobName) {
        try {
            this.scheduler.pauseJob(new JobKey(jobName));
        }
        catch (SchedulerException e) {
            log.error("\u6682\u505c\u4efb\u52a1[{}]\u5931\u8d25", (Object)jobName, (Object)e);
            throw new SystemException("\u6682\u505c\u4efb\u52a1" + jobName + "\u5931\u8d25");
        }
    }

    @Override
    public void resumeJob(String jobName) {
        try {
            this.scheduler.resumeJob(new JobKey(jobName));
        }
        catch (SchedulerException e) {
            log.error("\u6062\u590d\u4efb\u52a1[{}]\u5931\u8d25", (Object)jobName, (Object)e);
            throw new SystemException("\u6062\u590d\u4efb\u52a1" + jobName + "\u5931\u8d25");
        }
    }

    @Override
    public JobDTO getJob(String jobName) {
        try {
            Iterator iterator;
            JobKey jobKey = new JobKey(jobName);
            JobDetail jobDetail = this.scheduler.getJobDetail(jobKey);
            List triggers = this.scheduler.getTriggersOfJob(jobKey);
            if (!CollectionUtils.isEmpty((Collection)triggers) && (iterator = triggers.iterator()).hasNext()) {
                CronTrigger trigger = (CronTrigger)iterator.next();
                return this.newJobDTO(jobDetail, trigger);
            }
        }
        catch (SchedulerException e) {
            log.error("\u83b7\u53d6\u4efb\u52a1[{}]\u5931\u8d25", (Object)jobName, (Object)e);
            throw new SystemException("\u83b7\u53d6\u4efb\u52a1" + jobName + "\u5931\u8d25");
        }
        return null;
    }

    @Override
    public boolean updateJobCron(String jobName, String cron) {
        if (!CronExpression.isValidExpression((String)cron)) {
            log.error("Cron\u8868\u8fbe\u5f0f\u4e0d\u6b63\u786e({})", (Object)cron);
            return false;
        }
        try {
            List cronTriggers = this.scheduler.getTriggersOfJob(new JobKey(jobName));
            if (CollectionUtils.isEmpty((Collection)cronTriggers)) {
                log.error("\u4e0d\u5b58\u5728\u4efb\u52a1{}\uff0c\u66f4\u65b0cron[{}] \u5931\u8d25", (Object)jobName, (Object)cron);
                return false;
            }
            for (CronTrigger cronTrigger : cronTriggers) {
                Trigger newTrigger = cronTrigger.getTriggerBuilder().withSchedule((ScheduleBuilder)CronScheduleBuilder.cronSchedule((String)cron)).build();
                this.scheduler.rescheduleJob(cronTrigger.getKey(), newTrigger);
            }
            return true;
        }
        catch (SchedulerException e) {
            log.error("\u66f4\u65b0\u4efb\u52a1\u5931\u8d25:{}", (Object)jobName, (Object)e);
            return false;
        }
    }
}

