/*
 * Decompiled with CFR 0.152.
 */
package io.urf.config.urf;

import com.globalmentor.java.Conditions;
import io.confound.config.AbstractObjectConfiguration;
import io.confound.config.Configuration;
import io.confound.config.ConfigurationException;
import io.confound.config.Section;
import io.urf.URF;
import io.urf.model.UrfObject;
import java.net.URI;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class UrfConfiguration
extends AbstractObjectConfiguration
implements Section {
    private final Object root;
    private final Configuration sectionRoot;

    public Configuration getSectionRoot() {
        return this.sectionRoot != null ? this.sectionRoot : this;
    }

    public UrfConfiguration(@Nonnull Object root) {
        this(null, root);
    }

    protected UrfConfiguration(@Nullable Configuration sectionRoot, @Nonnull Object root) {
        this.sectionRoot = sectionRoot;
        this.root = Objects.requireNonNull(root);
    }

    public Optional<String> getSectionType() {
        return this.root instanceof UrfObject ? ((UrfObject)this.root).getTypeTag().map(tag -> URF.Handle.findFromTag((URI)tag).orElse(tag.toString())) : Optional.empty();
    }

    protected Optional<Object> findConfigurationValueImpl(String key) throws ConfigurationException {
        Object object = this.root;
        for (String keySegment : KEY_SEGMENTS_PATTERN.split(key, -1)) {
            Conditions.checkArgument((!keySegment.isEmpty() ? 1 : 0) != 0, (String)"Configuration key %s cannot have an empty hiararchy segment.", (Object[])new Object[]{key});
            if (object == null) continue;
            object = object instanceof UrfObject ? ((UrfObject)object).findPropertyValueByHandle(keySegment).orElse(null) : (object instanceof Map ? ((Map)object).get(Objects.requireNonNull(keySegment)) : null);
        }
        return Optional.ofNullable(object);
    }

    protected <O> Optional<O> convertValue(Optional<Object> value, Class<O> convertClass) throws ConfigurationException {
        if (value.isPresent()) {
            Object object = value.get();
            if (convertClass.isAssignableFrom(UrfConfiguration.class) && object instanceof UrfObject) {
                UrfObject urfObject = (UrfObject)object;
                UrfConfiguration section = new UrfConfiguration(this.getSectionRoot(), urfObject);
                return Optional.of(convertClass.cast((Object)section));
            }
            if (convertClass.equals(Path.class) && object instanceof String) {
                return Optional.of(convertClass.cast(Paths.get((String)object, new String[0])));
            }
        }
        return super.convertValue(value, convertClass);
    }
}

