/*
 * Decompiled with CFR 0.152.
 */
package glide.api;

import command_request.CommandRequestOuterClass;
import glide.api.BaseClient;
import glide.api.commands.ConnectionManagementClusterCommands;
import glide.api.commands.GenericClusterCommands;
import glide.api.commands.PubSubClusterCommands;
import glide.api.commands.ScriptingAndFunctionsClusterCommands;
import glide.api.commands.ServerManagementClusterCommands;
import glide.api.commands.TransactionsClusterCommands;
import glide.api.logging.Logger;
import glide.api.models.ClusterTransaction;
import glide.api.models.ClusterValue;
import glide.api.models.GlideString;
import glide.api.models.Script;
import glide.api.models.commands.FlushMode;
import glide.api.models.commands.InfoOptions;
import glide.api.models.commands.ScriptArgOptions;
import glide.api.models.commands.ScriptArgOptionsGlideString;
import glide.api.models.commands.function.FunctionLoadOptions;
import glide.api.models.commands.function.FunctionRestorePolicy;
import glide.api.models.commands.scan.ClusterScanCursor;
import glide.api.models.commands.scan.ScanOptions;
import glide.api.models.configuration.GlideClusterClientConfiguration;
import glide.api.models.configuration.RequestRoutingConfiguration;
import glide.ffi.resolvers.ClusterScanCursorResolver;
import glide.managers.CommandManager;
import glide.utils.ArgsBuilder;
import glide.utils.ArrayTransformUtils;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.NonNull;
import response.ResponseOuterClass;

public class GlideClusterClient
extends BaseClient
implements ConnectionManagementClusterCommands,
GenericClusterCommands,
ServerManagementClusterCommands,
ScriptingAndFunctionsClusterCommands,
TransactionsClusterCommands,
PubSubClusterCommands {
    GlideClusterClient(BaseClient.ClientBuilder builder) {
        super(builder);
    }

    public static CompletableFuture<GlideClusterClient> createClient(@NonNull GlideClusterClientConfiguration config) {
        if (config == null) {
            throw new NullPointerException("config is marked non-null but is null");
        }
        return GlideClusterClient.createClient(config, GlideClusterClient::new);
    }

    @Override
    public CompletableFuture<ClusterValue<Object>> customCommand(@NonNull String[] args) {
        if (args == null) {
            throw new NullPointerException("args is marked non-null but is null");
        }
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.CustomCommand, args, response -> ClusterValue.of(this.handleObjectOrNullResponse((ResponseOuterClass.Response)response)));
    }

    @Override
    public CompletableFuture<ClusterValue<Object>> customCommand(@NonNull GlideString[] args) {
        if (args == null) {
            throw new NullPointerException("args is marked non-null but is null");
        }
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.CustomCommand, args, response -> ClusterValue.of(this.handleBinaryObjectOrNullResponse((ResponseOuterClass.Response)response)));
    }

    @Override
    public CompletableFuture<ClusterValue<Object>> customCommand(@NonNull String[] args, @NonNull RequestRoutingConfiguration.Route route) {
        if (args == null) {
            throw new NullPointerException("args is marked non-null but is null");
        }
        if (route == null) {
            throw new NullPointerException("route is marked non-null but is null");
        }
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.CustomCommand, args, route, response -> this.handleCustomCommandResponse(route, (ResponseOuterClass.Response)response));
    }

    @Override
    public CompletableFuture<ClusterValue<Object>> customCommand(@NonNull GlideString[] args, @NonNull RequestRoutingConfiguration.Route route) {
        if (args == null) {
            throw new NullPointerException("args is marked non-null but is null");
        }
        if (route == null) {
            throw new NullPointerException("route is marked non-null but is null");
        }
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.CustomCommand, args, route, response -> this.handleCustomCommandBinaryResponse(route, (ResponseOuterClass.Response)response));
    }

    protected ClusterValue<Object> handleCustomCommandResponse(RequestRoutingConfiguration.Route route, ResponseOuterClass.Response response) {
        if (route instanceof RequestRoutingConfiguration.SingleNodeRoute) {
            return ClusterValue.ofSingleValue(this.handleObjectOrNullResponse(response));
        }
        if (response.hasConstantResponse()) {
            return ClusterValue.ofSingleValue(this.handleStringResponse(response));
        }
        return ClusterValue.ofMultiValue(this.handleMapResponse(response));
    }

    protected ClusterValue<Object> handleCustomCommandBinaryResponse(RequestRoutingConfiguration.Route route, ResponseOuterClass.Response response) {
        if (route instanceof RequestRoutingConfiguration.SingleNodeRoute) {
            return ClusterValue.ofSingleValue(this.handleBinaryObjectOrNullResponse(response));
        }
        if (response.hasConstantResponse()) {
            return ClusterValue.ofSingleValue(this.handleStringResponse(response));
        }
        return ClusterValue.ofMultiValueBinary(this.handleBinaryStringMapResponse(response));
    }

    @Override
    public CompletableFuture<Object[]> exec(@NonNull ClusterTransaction transaction) {
        if (transaction == null) {
            throw new NullPointerException("transaction is marked non-null but is null");
        }
        if (transaction.isBinaryOutput()) {
            return this.commandManager.submitNewTransaction(transaction, Optional.empty(), this::handleArrayOrNullResponseBinary);
        }
        return this.commandManager.submitNewTransaction(transaction, Optional.empty(), this::handleArrayOrNullResponse);
    }

    @Override
    public CompletableFuture<Object[]> exec(@NonNull ClusterTransaction transaction, @NonNull RequestRoutingConfiguration.SingleNodeRoute route) {
        if (transaction == null) {
            throw new NullPointerException("transaction is marked non-null but is null");
        }
        if (route == null) {
            throw new NullPointerException("route is marked non-null but is null");
        }
        if (transaction.isBinaryOutput()) {
            return this.commandManager.submitNewTransaction(transaction, Optional.of(route), this::handleArrayOrNullResponseBinary);
        }
        return this.commandManager.submitNewTransaction(transaction, Optional.of(route), this::handleArrayOrNullResponse);
    }

    @Override
    public CompletableFuture<String> ping() {
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.Ping, new String[0], this::handleStringResponse);
    }

    @Override
    public CompletableFuture<String> ping(@NonNull String message) {
        if (message == null) {
            throw new NullPointerException("message is marked non-null but is null");
        }
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.Ping, new String[]{message}, this::handleStringResponse);
    }

    @Override
    public CompletableFuture<GlideString> ping(@NonNull GlideString message) {
        if (message == null) {
            throw new NullPointerException("message is marked non-null but is null");
        }
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.Ping, new GlideString[]{message}, this::handleGlideStringResponse);
    }

    @Override
    public CompletableFuture<String> ping(@NonNull RequestRoutingConfiguration.Route route) {
        if (route == null) {
            throw new NullPointerException("route is marked non-null but is null");
        }
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.Ping, new String[0], route, this::handleStringResponse);
    }

    @Override
    public CompletableFuture<String> ping(@NonNull String message, @NonNull RequestRoutingConfiguration.Route route) {
        if (message == null) {
            throw new NullPointerException("message is marked non-null but is null");
        }
        if (route == null) {
            throw new NullPointerException("route is marked non-null but is null");
        }
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.Ping, new String[]{message}, route, this::handleStringResponse);
    }

    @Override
    public CompletableFuture<GlideString> ping(@NonNull GlideString message, @NonNull RequestRoutingConfiguration.Route route) {
        if (message == null) {
            throw new NullPointerException("message is marked non-null but is null");
        }
        if (route == null) {
            throw new NullPointerException("route is marked non-null but is null");
        }
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.Ping, new GlideString[]{message}, route, this::handleGlideStringResponse);
    }

    @Override
    public CompletableFuture<ClusterValue<String>> info() {
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.Info, new String[0], response -> ClusterValue.of(this.handleMapResponse((ResponseOuterClass.Response)response)));
    }

    @Override
    public CompletableFuture<ClusterValue<String>> info(@NonNull RequestRoutingConfiguration.Route route) {
        if (route == null) {
            throw new NullPointerException("route is marked non-null but is null");
        }
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.Info, new String[0], route, response -> route instanceof RequestRoutingConfiguration.SingleNodeRoute ? ClusterValue.of(this.handleStringResponse((ResponseOuterClass.Response)response)) : ClusterValue.of(this.handleMapResponse((ResponseOuterClass.Response)response)));
    }

    @Override
    public CompletableFuture<ClusterValue<String>> info(@NonNull InfoOptions.Section[] sections) {
        if (sections == null) {
            throw new NullPointerException("sections is marked non-null but is null");
        }
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.Info, (String[])Stream.of(sections).map(Enum::toString).toArray(String[]::new), response -> ClusterValue.of(this.handleMapResponse((ResponseOuterClass.Response)response)));
    }

    @Override
    public CompletableFuture<ClusterValue<String>> info(@NonNull InfoOptions.Section[] sections, @NonNull RequestRoutingConfiguration.Route route) {
        if (sections == null) {
            throw new NullPointerException("sections is marked non-null but is null");
        }
        if (route == null) {
            throw new NullPointerException("route is marked non-null but is null");
        }
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.Info, (String[])Stream.of(sections).map(Enum::toString).toArray(String[]::new), route, response -> route instanceof RequestRoutingConfiguration.SingleNodeRoute ? ClusterValue.of(this.handleStringResponse((ResponseOuterClass.Response)response)) : ClusterValue.of(this.handleMapResponse((ResponseOuterClass.Response)response)));
    }

    @Override
    public CompletableFuture<Long> clientId() {
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.ClientId, new String[0], this::handleLongResponse);
    }

    @Override
    public CompletableFuture<ClusterValue<Long>> clientId(@NonNull RequestRoutingConfiguration.Route route) {
        if (route == null) {
            throw new NullPointerException("route is marked non-null but is null");
        }
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.ClientId, new String[0], route, response -> route instanceof RequestRoutingConfiguration.SingleNodeRoute ? ClusterValue.of(this.handleLongResponse((ResponseOuterClass.Response)response)) : ClusterValue.of(this.handleMapResponse((ResponseOuterClass.Response)response)));
    }

    @Override
    public CompletableFuture<String> clientGetName() {
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.ClientGetName, new String[0], this::handleStringOrNullResponse);
    }

    @Override
    public CompletableFuture<ClusterValue<String>> clientGetName(@NonNull RequestRoutingConfiguration.Route route) {
        if (route == null) {
            throw new NullPointerException("route is marked non-null but is null");
        }
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.ClientGetName, new String[0], route, response -> route instanceof RequestRoutingConfiguration.SingleNodeRoute ? ClusterValue.of(this.handleStringOrNullResponse((ResponseOuterClass.Response)response)) : ClusterValue.of(this.handleMapResponse((ResponseOuterClass.Response)response)));
    }

    @Override
    public CompletableFuture<String> configRewrite() {
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.ConfigRewrite, new String[0], this::handleStringResponse);
    }

    @Override
    public CompletableFuture<String> configRewrite(@NonNull RequestRoutingConfiguration.Route route) {
        if (route == null) {
            throw new NullPointerException("route is marked non-null but is null");
        }
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.ConfigRewrite, new String[0], route, this::handleStringResponse);
    }

    @Override
    public CompletableFuture<String> configResetStat() {
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.ConfigResetStat, new String[0], this::handleStringResponse);
    }

    @Override
    public CompletableFuture<String> configResetStat(@NonNull RequestRoutingConfiguration.Route route) {
        if (route == null) {
            throw new NullPointerException("route is marked non-null but is null");
        }
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.ConfigResetStat, new String[0], route, this::handleStringResponse);
    }

    @Override
    public CompletableFuture<Map<String, String>> configGet(@NonNull String[] parameters) {
        if (parameters == null) {
            throw new NullPointerException("parameters is marked non-null but is null");
        }
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.ConfigGet, parameters, this::handleMapResponse);
    }

    @Override
    public CompletableFuture<ClusterValue<Map<String, String>>> configGet(@NonNull String[] parameters, @NonNull RequestRoutingConfiguration.Route route) {
        if (parameters == null) {
            throw new NullPointerException("parameters is marked non-null but is null");
        }
        if (route == null) {
            throw new NullPointerException("route is marked non-null but is null");
        }
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.ConfigGet, parameters, route, response -> route instanceof RequestRoutingConfiguration.SingleNodeRoute ? ClusterValue.ofSingleValue(this.handleMapResponse((ResponseOuterClass.Response)response)) : ClusterValue.ofMultiValue(this.handleMapResponse((ResponseOuterClass.Response)response)));
    }

    @Override
    public CompletableFuture<String> configSet(@NonNull Map<String, String> parameters) {
        if (parameters == null) {
            throw new NullPointerException("parameters is marked non-null but is null");
        }
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.ConfigSet, ArrayTransformUtils.convertMapToKeyValueStringArray(parameters), this::handleStringResponse);
    }

    @Override
    public CompletableFuture<String> configSet(@NonNull Map<String, String> parameters, @NonNull RequestRoutingConfiguration.Route route) {
        if (parameters == null) {
            throw new NullPointerException("parameters is marked non-null but is null");
        }
        if (route == null) {
            throw new NullPointerException("route is marked non-null but is null");
        }
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.ConfigSet, ArrayTransformUtils.convertMapToKeyValueStringArray(parameters), route, this::handleStringResponse);
    }

    @Override
    public CompletableFuture<String> echo(@NonNull String message) {
        if (message == null) {
            throw new NullPointerException("message is marked non-null but is null");
        }
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.Echo, new String[]{message}, this::handleStringResponse);
    }

    @Override
    public CompletableFuture<GlideString> echo(@NonNull GlideString message) {
        if (message == null) {
            throw new NullPointerException("message is marked non-null but is null");
        }
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.Echo, new GlideString[]{message}, this::handleGlideStringResponse);
    }

    @Override
    public CompletableFuture<ClusterValue<String>> echo(@NonNull String message, @NonNull RequestRoutingConfiguration.Route route) {
        if (message == null) {
            throw new NullPointerException("message is marked non-null but is null");
        }
        if (route == null) {
            throw new NullPointerException("route is marked non-null but is null");
        }
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.Echo, new String[]{message}, route, response -> route instanceof RequestRoutingConfiguration.SingleNodeRoute ? ClusterValue.ofSingleValue(this.handleStringResponse((ResponseOuterClass.Response)response)) : ClusterValue.ofMultiValue(this.handleMapResponse((ResponseOuterClass.Response)response)));
    }

    @Override
    public CompletableFuture<ClusterValue<GlideString>> echo(@NonNull GlideString message, @NonNull RequestRoutingConfiguration.Route route) {
        if (message == null) {
            throw new NullPointerException("message is marked non-null but is null");
        }
        if (route == null) {
            throw new NullPointerException("route is marked non-null but is null");
        }
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.Echo, new GlideString[]{message}, route, response -> route instanceof RequestRoutingConfiguration.SingleNodeRoute ? ClusterValue.ofSingleValue(this.handleGlideStringResponse((ResponseOuterClass.Response)response)) : ClusterValue.ofMultiValueBinary(this.handleBinaryStringMapResponse((ResponseOuterClass.Response)response)));
    }

    @Override
    public CompletableFuture<String[]> time() {
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.Time, new String[0], response -> ArrayTransformUtils.castArray(this.handleArrayResponse((ResponseOuterClass.Response)response), String.class));
    }

    @Override
    public CompletableFuture<ClusterValue<String[]>> time(@NonNull RequestRoutingConfiguration.Route route) {
        if (route == null) {
            throw new NullPointerException("route is marked non-null but is null");
        }
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.Time, new String[0], route, response -> route instanceof RequestRoutingConfiguration.SingleNodeRoute ? ClusterValue.ofSingleValue(ArrayTransformUtils.castArray(this.handleArrayResponse((ResponseOuterClass.Response)response), String.class)) : ClusterValue.ofMultiValue(ArrayTransformUtils.castMapOfArrays(this.handleMapResponse((ResponseOuterClass.Response)response), String.class)));
    }

    @Override
    public CompletableFuture<Long> lastsave() {
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.LastSave, new String[0], this::handleLongResponse);
    }

    @Override
    public CompletableFuture<ClusterValue<Long>> lastsave(@NonNull RequestRoutingConfiguration.Route route) {
        if (route == null) {
            throw new NullPointerException("route is marked non-null but is null");
        }
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.LastSave, new String[0], route, response -> route instanceof RequestRoutingConfiguration.SingleNodeRoute ? ClusterValue.of(this.handleLongResponse((ResponseOuterClass.Response)response)) : ClusterValue.of(this.handleMapResponse((ResponseOuterClass.Response)response)));
    }

    @Override
    public CompletableFuture<String> flushall() {
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.FlushAll, new String[0], this::handleStringResponse);
    }

    @Override
    public CompletableFuture<String> flushall(@NonNull FlushMode mode) {
        if (mode == null) {
            throw new NullPointerException("mode is marked non-null but is null");
        }
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.FlushAll, new String[]{mode.toString()}, this::handleStringResponse);
    }

    @Override
    public CompletableFuture<String> flushall(@NonNull RequestRoutingConfiguration.Route route) {
        if (route == null) {
            throw new NullPointerException("route is marked non-null but is null");
        }
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.FlushAll, new String[0], route, this::handleStringResponse);
    }

    @Override
    public CompletableFuture<String> flushall(@NonNull FlushMode mode, @NonNull RequestRoutingConfiguration.Route route) {
        if (mode == null) {
            throw new NullPointerException("mode is marked non-null but is null");
        }
        if (route == null) {
            throw new NullPointerException("route is marked non-null but is null");
        }
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.FlushAll, new String[]{mode.toString()}, route, this::handleStringResponse);
    }

    @Override
    public CompletableFuture<String> flushdb() {
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.FlushDB, new String[0], this::handleStringResponse);
    }

    @Override
    public CompletableFuture<String> flushdb(@NonNull FlushMode mode) {
        if (mode == null) {
            throw new NullPointerException("mode is marked non-null but is null");
        }
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.FlushDB, new String[]{mode.toString()}, this::handleStringResponse);
    }

    @Override
    public CompletableFuture<String> flushdb(@NonNull RequestRoutingConfiguration.Route route) {
        if (route == null) {
            throw new NullPointerException("route is marked non-null but is null");
        }
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.FlushDB, new String[0], route, this::handleStringResponse);
    }

    @Override
    public CompletableFuture<String> flushdb(@NonNull FlushMode mode, @NonNull RequestRoutingConfiguration.Route route) {
        if (mode == null) {
            throw new NullPointerException("mode is marked non-null but is null");
        }
        if (route == null) {
            throw new NullPointerException("route is marked non-null but is null");
        }
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.FlushDB, new String[]{mode.toString()}, route, this::handleStringResponse);
    }

    @Override
    public CompletableFuture<String> lolwut() {
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.Lolwut, new String[0], this::handleStringResponse);
    }

    @Override
    public CompletableFuture<String> lolwut(int @NonNull [] parameters) {
        if (parameters == null) {
            throw new NullPointerException("parameters is marked non-null but is null");
        }
        String[] arguments = (String[])Arrays.stream(parameters).mapToObj(Integer::toString).toArray(String[]::new);
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.Lolwut, arguments, this::handleStringResponse);
    }

    @Override
    public CompletableFuture<String> lolwut(int version) {
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.Lolwut, new String[]{"VERSION", Integer.toString(version)}, this::handleStringResponse);
    }

    @Override
    public CompletableFuture<String> lolwut(int version, int @NonNull [] parameters) {
        if (parameters == null) {
            throw new NullPointerException("parameters is marked non-null but is null");
        }
        String[] arguments = ArrayTransformUtils.concatenateArrays({"VERSION", Integer.toString(version)}, (String[])Arrays.stream(parameters).mapToObj(Integer::toString).toArray(String[]::new));
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.Lolwut, arguments, this::handleStringResponse);
    }

    @Override
    public CompletableFuture<ClusterValue<String>> lolwut(@NonNull RequestRoutingConfiguration.Route route) {
        if (route == null) {
            throw new NullPointerException("route is marked non-null but is null");
        }
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.Lolwut, new String[0], route, response -> route instanceof RequestRoutingConfiguration.SingleNodeRoute ? ClusterValue.ofSingleValue(this.handleStringResponse((ResponseOuterClass.Response)response)) : ClusterValue.ofMultiValue(this.handleMapResponse((ResponseOuterClass.Response)response)));
    }

    @Override
    public CompletableFuture<ClusterValue<String>> lolwut(int @NonNull [] parameters, @NonNull RequestRoutingConfiguration.Route route) {
        if (parameters == null) {
            throw new NullPointerException("parameters is marked non-null but is null");
        }
        if (route == null) {
            throw new NullPointerException("route is marked non-null but is null");
        }
        String[] arguments = (String[])Arrays.stream(parameters).mapToObj(Integer::toString).toArray(String[]::new);
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.Lolwut, arguments, route, response -> route instanceof RequestRoutingConfiguration.SingleNodeRoute ? ClusterValue.ofSingleValue(this.handleStringResponse((ResponseOuterClass.Response)response)) : ClusterValue.ofMultiValue(this.handleMapResponse((ResponseOuterClass.Response)response)));
    }

    @Override
    public CompletableFuture<ClusterValue<String>> lolwut(int version, @NonNull RequestRoutingConfiguration.Route route) {
        if (route == null) {
            throw new NullPointerException("route is marked non-null but is null");
        }
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.Lolwut, new String[]{"VERSION", Integer.toString(version)}, route, response -> route instanceof RequestRoutingConfiguration.SingleNodeRoute ? ClusterValue.ofSingleValue(this.handleStringResponse((ResponseOuterClass.Response)response)) : ClusterValue.ofMultiValue(this.handleMapResponse((ResponseOuterClass.Response)response)));
    }

    @Override
    public CompletableFuture<ClusterValue<String>> lolwut(int version, int @NonNull [] parameters, @NonNull RequestRoutingConfiguration.Route route) {
        if (parameters == null) {
            throw new NullPointerException("parameters is marked non-null but is null");
        }
        if (route == null) {
            throw new NullPointerException("route is marked non-null but is null");
        }
        String[] arguments = ArrayTransformUtils.concatenateArrays({"VERSION", Integer.toString(version)}, (String[])Arrays.stream(parameters).mapToObj(Integer::toString).toArray(String[]::new));
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.Lolwut, arguments, route, response -> route instanceof RequestRoutingConfiguration.SingleNodeRoute ? ClusterValue.ofSingleValue(this.handleStringResponse((ResponseOuterClass.Response)response)) : ClusterValue.ofMultiValue(this.handleMapResponse((ResponseOuterClass.Response)response)));
    }

    @Override
    public CompletableFuture<Long> dbsize() {
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.DBSize, new String[0], this::handleLongResponse);
    }

    @Override
    public CompletableFuture<Long> dbsize(@NonNull RequestRoutingConfiguration.Route route) {
        if (route == null) {
            throw new NullPointerException("route is marked non-null but is null");
        }
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.DBSize, new String[0], route, this::handleLongResponse);
    }

    @Override
    public CompletableFuture<String> functionLoad(@NonNull String libraryCode, boolean replace) {
        String[] stringArray;
        if (libraryCode == null) {
            throw new NullPointerException("libraryCode is marked non-null but is null");
        }
        if (replace) {
            String[] stringArray2 = new String[2];
            stringArray2[0] = FunctionLoadOptions.REPLACE.toString();
            stringArray = stringArray2;
            stringArray2[1] = libraryCode;
        } else {
            String[] stringArray3 = new String[1];
            stringArray = stringArray3;
            stringArray3[0] = libraryCode;
        }
        String[] arguments = stringArray;
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.FunctionLoad, arguments, this::handleStringResponse);
    }

    @Override
    public CompletableFuture<GlideString> functionLoad(@NonNull GlideString libraryCode, boolean replace) {
        GlideString[] glideStringArray;
        if (libraryCode == null) {
            throw new NullPointerException("libraryCode is marked non-null but is null");
        }
        if (replace) {
            GlideString[] glideStringArray2 = new GlideString[2];
            glideStringArray2[0] = GlideString.gs(FunctionLoadOptions.REPLACE.toString());
            glideStringArray = glideStringArray2;
            glideStringArray2[1] = libraryCode;
        } else {
            GlideString[] glideStringArray3 = new GlideString[1];
            glideStringArray = glideStringArray3;
            glideStringArray3[0] = libraryCode;
        }
        GlideString[] arguments = glideStringArray;
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.FunctionLoad, arguments, this::handleGlideStringResponse);
    }

    @Override
    public CompletableFuture<String> functionLoad(@NonNull String libraryCode, boolean replace, @NonNull RequestRoutingConfiguration.Route route) {
        String[] stringArray;
        if (libraryCode == null) {
            throw new NullPointerException("libraryCode is marked non-null but is null");
        }
        if (route == null) {
            throw new NullPointerException("route is marked non-null but is null");
        }
        if (replace) {
            String[] stringArray2 = new String[2];
            stringArray2[0] = FunctionLoadOptions.REPLACE.toString();
            stringArray = stringArray2;
            stringArray2[1] = libraryCode;
        } else {
            String[] stringArray3 = new String[1];
            stringArray = stringArray3;
            stringArray3[0] = libraryCode;
        }
        String[] arguments = stringArray;
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.FunctionLoad, arguments, route, this::handleStringResponse);
    }

    @Override
    public CompletableFuture<GlideString> functionLoad(@NonNull GlideString libraryCode, boolean replace, @NonNull RequestRoutingConfiguration.Route route) {
        GlideString[] glideStringArray;
        if (libraryCode == null) {
            throw new NullPointerException("libraryCode is marked non-null but is null");
        }
        if (route == null) {
            throw new NullPointerException("route is marked non-null but is null");
        }
        if (replace) {
            GlideString[] glideStringArray2 = new GlideString[2];
            glideStringArray2[0] = GlideString.gs(FunctionLoadOptions.REPLACE.toString());
            glideStringArray = glideStringArray2;
            glideStringArray2[1] = libraryCode;
        } else {
            GlideString[] glideStringArray3 = new GlideString[1];
            glideStringArray = glideStringArray3;
            glideStringArray3[0] = libraryCode;
        }
        GlideString[] arguments = glideStringArray;
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.FunctionLoad, arguments, route, this::handleGlideStringResponse);
    }

    protected ClusterValue<Map<String, Object>[]> handleFunctionListResponse(ResponseOuterClass.Response response, RequestRoutingConfiguration.Route route) {
        if (route instanceof RequestRoutingConfiguration.SingleNodeRoute) {
            Map<String, Object>[] data = this.handleFunctionListResponse(this.handleArrayResponse(response));
            return ClusterValue.ofSingleValue(data);
        }
        Map info = this.handleMapResponse(response);
        HashMap<String, Map<String, Object>[]> data = new HashMap<String, Map<String, Object>[]>();
        for (Map.Entry nodeInfo : info.entrySet()) {
            data.put(nodeInfo.getKey(), this.handleFunctionListResponse((Object[])nodeInfo.getValue()));
        }
        return ClusterValue.ofMultiValue(data);
    }

    protected ClusterValue<Map<GlideString, Object>[]> handleFunctionListResponseBinary(ResponseOuterClass.Response response, RequestRoutingConfiguration.Route route) {
        if (route instanceof RequestRoutingConfiguration.SingleNodeRoute) {
            Map<GlideString, Object>[] data = this.handleFunctionListResponseBinary(this.handleArrayResponseBinary(response));
            return ClusterValue.ofSingleValue(data);
        }
        Map info = this.handleBinaryStringMapResponse(response);
        HashMap<GlideString, Map<GlideString, Object>[]> data = new HashMap<GlideString, Map<GlideString, Object>[]>();
        for (Map.Entry nodeInfo : info.entrySet()) {
            data.put(nodeInfo.getKey(), this.handleFunctionListResponseBinary((Object[])nodeInfo.getValue()));
        }
        return ClusterValue.ofMultiValueBinary(data);
    }

    @Override
    public CompletableFuture<Map<String, Object>[]> functionList(boolean withCode) {
        String[] stringArray;
        if (withCode) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = "WITHCODE";
        } else {
            stringArray = new String[]{};
        }
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.FunctionList, stringArray, response -> this.handleFunctionListResponse(this.handleArrayResponse((ResponseOuterClass.Response)response)));
    }

    @Override
    public CompletableFuture<Map<GlideString, Object>[]> functionListBinary(boolean withCode) {
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.FunctionList, new ArgsBuilder().addIf("WITHCODE", withCode).toArray(), response -> this.handleFunctionListResponseBinary(this.handleArrayResponseBinary((ResponseOuterClass.Response)response)));
    }

    @Override
    public CompletableFuture<Map<String, Object>[]> functionList(@NonNull String libNamePattern, boolean withCode) {
        String[] stringArray;
        if (libNamePattern == null) {
            throw new NullPointerException("libNamePattern is marked non-null but is null");
        }
        if (withCode) {
            String[] stringArray2 = new String[3];
            stringArray2[0] = "LIBRARYNAME";
            stringArray2[1] = libNamePattern;
            stringArray = stringArray2;
            stringArray2[2] = "WITHCODE";
        } else {
            String[] stringArray3 = new String[2];
            stringArray3[0] = "LIBRARYNAME";
            stringArray = stringArray3;
            stringArray3[1] = libNamePattern;
        }
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.FunctionList, stringArray, response -> this.handleFunctionListResponse(this.handleArrayResponse((ResponseOuterClass.Response)response)));
    }

    @Override
    public CompletableFuture<Map<GlideString, Object>[]> functionListBinary(@NonNull GlideString libNamePattern, boolean withCode) {
        if (libNamePattern == null) {
            throw new NullPointerException("libNamePattern is marked non-null but is null");
        }
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.FunctionList, new ArgsBuilder().add("LIBRARYNAME").add(libNamePattern).addIf("WITHCODE", withCode).toArray(), response -> this.handleFunctionListResponseBinary(this.handleArrayResponseBinary((ResponseOuterClass.Response)response)));
    }

    @Override
    public CompletableFuture<ClusterValue<Map<String, Object>[]>> functionList(boolean withCode, @NonNull RequestRoutingConfiguration.Route route) {
        String[] stringArray;
        if (route == null) {
            throw new NullPointerException("route is marked non-null but is null");
        }
        if (withCode) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = "WITHCODE";
        } else {
            stringArray = new String[]{};
        }
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.FunctionList, stringArray, route, response -> this.handleFunctionListResponse((ResponseOuterClass.Response)response, route));
    }

    @Override
    public CompletableFuture<ClusterValue<Map<GlideString, Object>[]>> functionListBinary(boolean withCode, @NonNull RequestRoutingConfiguration.Route route) {
        if (route == null) {
            throw new NullPointerException("route is marked non-null but is null");
        }
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.FunctionList, new ArgsBuilder().addIf("WITHCODE", withCode).toArray(), route, response -> this.handleFunctionListResponseBinary((ResponseOuterClass.Response)response, route));
    }

    @Override
    public CompletableFuture<ClusterValue<Map<String, Object>[]>> functionList(@NonNull String libNamePattern, boolean withCode, @NonNull RequestRoutingConfiguration.Route route) {
        String[] stringArray;
        if (libNamePattern == null) {
            throw new NullPointerException("libNamePattern is marked non-null but is null");
        }
        if (route == null) {
            throw new NullPointerException("route is marked non-null but is null");
        }
        if (withCode) {
            String[] stringArray2 = new String[3];
            stringArray2[0] = "LIBRARYNAME";
            stringArray2[1] = libNamePattern;
            stringArray = stringArray2;
            stringArray2[2] = "WITHCODE";
        } else {
            String[] stringArray3 = new String[2];
            stringArray3[0] = "LIBRARYNAME";
            stringArray = stringArray3;
            stringArray3[1] = libNamePattern;
        }
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.FunctionList, stringArray, route, response -> this.handleFunctionListResponse((ResponseOuterClass.Response)response, route));
    }

    @Override
    public CompletableFuture<ClusterValue<Map<GlideString, Object>[]>> functionListBinary(@NonNull GlideString libNamePattern, boolean withCode, @NonNull RequestRoutingConfiguration.Route route) {
        if (libNamePattern == null) {
            throw new NullPointerException("libNamePattern is marked non-null but is null");
        }
        if (route == null) {
            throw new NullPointerException("route is marked non-null but is null");
        }
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.FunctionList, new ArgsBuilder().add("LIBRARYNAME").add(libNamePattern).addIf("WITHCODE", withCode).toArray(), route, response -> this.handleFunctionListResponseBinary((ResponseOuterClass.Response)response, route));
    }

    @Override
    public CompletableFuture<String> functionFlush() {
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.FunctionFlush, new String[0], this::handleStringResponse);
    }

    @Override
    public CompletableFuture<String> functionFlush(@NonNull FlushMode mode) {
        if (mode == null) {
            throw new NullPointerException("mode is marked non-null but is null");
        }
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.FunctionFlush, new String[]{mode.toString()}, this::handleStringResponse);
    }

    @Override
    public CompletableFuture<String> functionFlush(@NonNull RequestRoutingConfiguration.Route route) {
        if (route == null) {
            throw new NullPointerException("route is marked non-null but is null");
        }
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.FunctionFlush, new String[0], route, this::handleStringResponse);
    }

    @Override
    public CompletableFuture<String> functionFlush(@NonNull FlushMode mode, @NonNull RequestRoutingConfiguration.Route route) {
        if (mode == null) {
            throw new NullPointerException("mode is marked non-null but is null");
        }
        if (route == null) {
            throw new NullPointerException("route is marked non-null but is null");
        }
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.FunctionFlush, new String[]{mode.toString()}, route, this::handleStringResponse);
    }

    @Override
    public CompletableFuture<String> functionDelete(@NonNull String libName) {
        if (libName == null) {
            throw new NullPointerException("libName is marked non-null but is null");
        }
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.FunctionDelete, new String[]{libName}, this::handleStringResponse);
    }

    @Override
    public CompletableFuture<String> functionDelete(@NonNull GlideString libName) {
        if (libName == null) {
            throw new NullPointerException("libName is marked non-null but is null");
        }
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.FunctionDelete, new GlideString[]{libName}, this::handleStringResponse);
    }

    @Override
    public CompletableFuture<String> functionDelete(@NonNull String libName, @NonNull RequestRoutingConfiguration.Route route) {
        if (libName == null) {
            throw new NullPointerException("libName is marked non-null but is null");
        }
        if (route == null) {
            throw new NullPointerException("route is marked non-null but is null");
        }
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.FunctionDelete, new String[]{libName}, route, this::handleStringResponse);
    }

    @Override
    public CompletableFuture<String> functionDelete(@NonNull GlideString libName, @NonNull RequestRoutingConfiguration.Route route) {
        if (libName == null) {
            throw new NullPointerException("libName is marked non-null but is null");
        }
        if (route == null) {
            throw new NullPointerException("route is marked non-null but is null");
        }
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.FunctionDelete, new GlideString[]{libName}, route, this::handleStringResponse);
    }

    @Override
    public CompletableFuture<byte[]> functionDump() {
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.FunctionDump, new GlideString[0], this::handleBytesOrNullResponse);
    }

    @Override
    public CompletableFuture<ClusterValue<byte[]>> functionDump(@NonNull RequestRoutingConfiguration.Route route) {
        if (route == null) {
            throw new NullPointerException("route is marked non-null but is null");
        }
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.FunctionDump, new GlideString[0], route, response -> route instanceof RequestRoutingConfiguration.SingleNodeRoute ? ClusterValue.ofSingleValue(this.handleBytesOrNullResponse((ResponseOuterClass.Response)response)) : ClusterValue.ofMultiValueBinary(this.handleBinaryStringMapResponse((ResponseOuterClass.Response)response)));
    }

    @Override
    public CompletableFuture<String> functionRestore(byte @NonNull [] payload) {
        if (payload == null) {
            throw new NullPointerException("payload is marked non-null but is null");
        }
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.FunctionRestore, new GlideString[]{GlideString.gs(payload)}, this::handleStringResponse);
    }

    @Override
    public CompletableFuture<String> functionRestore(byte @NonNull [] payload, @NonNull FunctionRestorePolicy policy) {
        if (payload == null) {
            throw new NullPointerException("payload is marked non-null but is null");
        }
        if (policy == null) {
            throw new NullPointerException("policy is marked non-null but is null");
        }
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.FunctionRestore, new GlideString[]{GlideString.gs(payload), GlideString.gs(policy.toString())}, this::handleStringResponse);
    }

    @Override
    public CompletableFuture<String> functionRestore(byte @NonNull [] payload, @NonNull RequestRoutingConfiguration.Route route) {
        if (payload == null) {
            throw new NullPointerException("payload is marked non-null but is null");
        }
        if (route == null) {
            throw new NullPointerException("route is marked non-null but is null");
        }
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.FunctionRestore, new GlideString[]{GlideString.gs(payload)}, route, this::handleStringResponse);
    }

    @Override
    public CompletableFuture<String> functionRestore(byte @NonNull [] payload, @NonNull FunctionRestorePolicy policy, @NonNull RequestRoutingConfiguration.Route route) {
        if (payload == null) {
            throw new NullPointerException("payload is marked non-null but is null");
        }
        if (policy == null) {
            throw new NullPointerException("policy is marked non-null but is null");
        }
        if (route == null) {
            throw new NullPointerException("route is marked non-null but is null");
        }
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.FunctionRestore, new GlideString[]{GlideString.gs(payload), GlideString.gs(policy.toString())}, route, this::handleStringResponse);
    }

    @Override
    public CompletableFuture<Object> fcall(@NonNull String function) {
        if (function == null) {
            throw new NullPointerException("function is marked non-null but is null");
        }
        return this.fcall(function, new String[0]);
    }

    @Override
    public CompletableFuture<Object> fcall(@NonNull GlideString function) {
        if (function == null) {
            throw new NullPointerException("function is marked non-null but is null");
        }
        return this.fcall(function, new GlideString[0]);
    }

    @Override
    public CompletableFuture<ClusterValue<Object>> fcall(@NonNull String function, @NonNull RequestRoutingConfiguration.Route route) {
        if (function == null) {
            throw new NullPointerException("function is marked non-null but is null");
        }
        if (route == null) {
            throw new NullPointerException("route is marked non-null but is null");
        }
        return this.fcall(function, new String[0], route);
    }

    @Override
    public CompletableFuture<ClusterValue<Object>> fcall(@NonNull GlideString function, @NonNull RequestRoutingConfiguration.Route route) {
        if (function == null) {
            throw new NullPointerException("function is marked non-null but is null");
        }
        if (route == null) {
            throw new NullPointerException("route is marked non-null but is null");
        }
        return this.fcall(function, new GlideString[0], route);
    }

    @Override
    public CompletableFuture<Object> fcall(@NonNull String function, @NonNull String[] arguments) {
        if (function == null) {
            throw new NullPointerException("function is marked non-null but is null");
        }
        if (arguments == null) {
            throw new NullPointerException("arguments is marked non-null but is null");
        }
        String[] args = ArrayTransformUtils.concatenateArrays({function, "0"}, arguments);
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.FCall, args, this::handleObjectOrNullResponse);
    }

    @Override
    public CompletableFuture<Object> fcall(@NonNull GlideString function, @NonNull GlideString[] arguments) {
        if (function == null) {
            throw new NullPointerException("function is marked non-null but is null");
        }
        if (arguments == null) {
            throw new NullPointerException("arguments is marked non-null but is null");
        }
        GlideString[] args = ArrayTransformUtils.concatenateArrays({function, GlideString.gs("0")}, arguments);
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.FCall, args, this::handleBinaryObjectOrNullResponse);
    }

    @Override
    public CompletableFuture<ClusterValue<Object>> fcall(@NonNull String function, @NonNull String[] arguments, @NonNull RequestRoutingConfiguration.Route route) {
        if (function == null) {
            throw new NullPointerException("function is marked non-null but is null");
        }
        if (arguments == null) {
            throw new NullPointerException("arguments is marked non-null but is null");
        }
        if (route == null) {
            throw new NullPointerException("route is marked non-null but is null");
        }
        String[] args = ArrayTransformUtils.concatenateArrays({function, "0"}, arguments);
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.FCall, args, route, response -> route instanceof RequestRoutingConfiguration.SingleNodeRoute ? ClusterValue.ofSingleValue(this.handleObjectOrNullResponse((ResponseOuterClass.Response)response)) : ClusterValue.ofMultiValue(this.handleMapResponse((ResponseOuterClass.Response)response)));
    }

    @Override
    public CompletableFuture<ClusterValue<Object>> fcall(@NonNull GlideString function, @NonNull GlideString[] arguments, @NonNull RequestRoutingConfiguration.Route route) {
        if (function == null) {
            throw new NullPointerException("function is marked non-null but is null");
        }
        if (arguments == null) {
            throw new NullPointerException("arguments is marked non-null but is null");
        }
        if (route == null) {
            throw new NullPointerException("route is marked non-null but is null");
        }
        GlideString[] args = ArrayTransformUtils.concatenateArrays({function, GlideString.gs("0")}, arguments);
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.FCall, args, route, response -> route instanceof RequestRoutingConfiguration.SingleNodeRoute ? ClusterValue.ofSingleValue(this.handleBinaryObjectOrNullResponse((ResponseOuterClass.Response)response)) : ClusterValue.ofMultiValueBinary(this.handleBinaryStringMapResponse((ResponseOuterClass.Response)response)));
    }

    @Override
    public CompletableFuture<Object> fcallReadOnly(@NonNull String function) {
        if (function == null) {
            throw new NullPointerException("function is marked non-null but is null");
        }
        return this.fcallReadOnly(function, new String[0]);
    }

    @Override
    public CompletableFuture<Object> fcallReadOnly(@NonNull GlideString function) {
        if (function == null) {
            throw new NullPointerException("function is marked non-null but is null");
        }
        return this.fcallReadOnly(function, new GlideString[0]);
    }

    @Override
    public CompletableFuture<ClusterValue<Object>> fcallReadOnly(@NonNull String function, @NonNull RequestRoutingConfiguration.Route route) {
        if (function == null) {
            throw new NullPointerException("function is marked non-null but is null");
        }
        if (route == null) {
            throw new NullPointerException("route is marked non-null but is null");
        }
        return this.fcallReadOnly(function, new String[0], route);
    }

    @Override
    public CompletableFuture<ClusterValue<Object>> fcallReadOnly(@NonNull GlideString function, @NonNull RequestRoutingConfiguration.Route route) {
        if (function == null) {
            throw new NullPointerException("function is marked non-null but is null");
        }
        if (route == null) {
            throw new NullPointerException("route is marked non-null but is null");
        }
        return this.fcallReadOnly(function, new GlideString[0], route);
    }

    @Override
    public CompletableFuture<Object> fcallReadOnly(@NonNull String function, @NonNull String[] arguments) {
        if (function == null) {
            throw new NullPointerException("function is marked non-null but is null");
        }
        if (arguments == null) {
            throw new NullPointerException("arguments is marked non-null but is null");
        }
        String[] args = ArrayTransformUtils.concatenateArrays({function, "0"}, arguments);
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.FCallReadOnly, args, this::handleObjectOrNullResponse);
    }

    @Override
    public CompletableFuture<Object> fcallReadOnly(@NonNull GlideString function, @NonNull GlideString[] arguments) {
        if (function == null) {
            throw new NullPointerException("function is marked non-null but is null");
        }
        if (arguments == null) {
            throw new NullPointerException("arguments is marked non-null but is null");
        }
        GlideString[] args = ArrayTransformUtils.concatenateArrays({function, GlideString.gs("0")}, arguments);
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.FCallReadOnly, args, this::handleBinaryObjectOrNullResponse);
    }

    @Override
    public CompletableFuture<ClusterValue<Object>> fcallReadOnly(@NonNull String function, @NonNull String[] arguments, @NonNull RequestRoutingConfiguration.Route route) {
        if (function == null) {
            throw new NullPointerException("function is marked non-null but is null");
        }
        if (arguments == null) {
            throw new NullPointerException("arguments is marked non-null but is null");
        }
        if (route == null) {
            throw new NullPointerException("route is marked non-null but is null");
        }
        String[] args = ArrayTransformUtils.concatenateArrays({function, "0"}, arguments);
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.FCallReadOnly, args, route, response -> route instanceof RequestRoutingConfiguration.SingleNodeRoute ? ClusterValue.ofSingleValue(this.handleObjectOrNullResponse((ResponseOuterClass.Response)response)) : ClusterValue.ofMultiValue(this.handleMapResponse((ResponseOuterClass.Response)response)));
    }

    @Override
    public CompletableFuture<ClusterValue<Object>> fcallReadOnly(@NonNull GlideString function, @NonNull GlideString[] arguments, @NonNull RequestRoutingConfiguration.Route route) {
        if (function == null) {
            throw new NullPointerException("function is marked non-null but is null");
        }
        if (arguments == null) {
            throw new NullPointerException("arguments is marked non-null but is null");
        }
        if (route == null) {
            throw new NullPointerException("route is marked non-null but is null");
        }
        GlideString[] args = ArrayTransformUtils.concatenateArrays({function, GlideString.gs("0")}, arguments);
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.FCallReadOnly, args, route, response -> route instanceof RequestRoutingConfiguration.SingleNodeRoute ? ClusterValue.ofSingleValue(this.handleBinaryObjectOrNullResponse((ResponseOuterClass.Response)response)) : ClusterValue.ofMultiValueBinary(this.handleBinaryStringMapResponse((ResponseOuterClass.Response)response)));
    }

    @Override
    public CompletableFuture<String> functionKill() {
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.FunctionKill, new String[0], this::handleStringResponse);
    }

    @Override
    public CompletableFuture<String> functionKill(@NonNull RequestRoutingConfiguration.Route route) {
        if (route == null) {
            throw new NullPointerException("route is marked non-null but is null");
        }
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.FunctionKill, new String[0], route, this::handleStringResponse);
    }

    @Override
    public CompletableFuture<Object> invokeScript(@NonNull Script script, @NonNull RequestRoutingConfiguration.Route route) {
        if (script == null) {
            throw new NullPointerException("script is marked non-null but is null");
        }
        if (route == null) {
            throw new NullPointerException("route is marked non-null but is null");
        }
        if (script.getBinaryOutput().booleanValue()) {
            return this.commandManager.submitScript(script, List.of(), route, this::handleBinaryObjectOrNullResponse);
        }
        return this.commandManager.submitScript(script, List.of(), route, this::handleObjectOrNullResponse);
    }

    @Override
    public CompletableFuture<Object> invokeScript(@NonNull Script script, @NonNull ScriptArgOptions options, @NonNull RequestRoutingConfiguration.Route route) {
        if (script == null) {
            throw new NullPointerException("script is marked non-null but is null");
        }
        if (options == null) {
            throw new NullPointerException("options is marked non-null but is null");
        }
        if (route == null) {
            throw new NullPointerException("route is marked non-null but is null");
        }
        return this.commandManager.submitScript(script, options.getArgs().stream().map(GlideString::gs).collect(Collectors.toList()), route, script.getBinaryOutput() != false ? this::handleBinaryObjectOrNullResponse : this::handleObjectOrNullResponse);
    }

    @Override
    public CompletableFuture<Object> invokeScript(@NonNull Script script, @NonNull ScriptArgOptionsGlideString options, @NonNull RequestRoutingConfiguration.Route route) {
        if (script == null) {
            throw new NullPointerException("script is marked non-null but is null");
        }
        if (options == null) {
            throw new NullPointerException("options is marked non-null but is null");
        }
        if (route == null) {
            throw new NullPointerException("route is marked non-null but is null");
        }
        return this.commandManager.submitScript(script, options.getArgs(), route, script.getBinaryOutput() != false ? this::handleBinaryObjectOrNullResponse : this::handleObjectOrNullResponse);
    }

    @Override
    public CompletableFuture<Boolean[]> scriptExists(@NonNull String[] sha1s) {
        if (sha1s == null) {
            throw new NullPointerException("sha1s is marked non-null but is null");
        }
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.ScriptExists, sha1s, response -> ArrayTransformUtils.castArray(this.handleArrayResponse((ResponseOuterClass.Response)response), Boolean.class));
    }

    @Override
    public CompletableFuture<Boolean[]> scriptExists(@NonNull GlideString[] sha1s) {
        if (sha1s == null) {
            throw new NullPointerException("sha1s is marked non-null but is null");
        }
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.ScriptExists, sha1s, response -> ArrayTransformUtils.castArray(this.handleArrayResponse((ResponseOuterClass.Response)response), Boolean.class));
    }

    @Override
    public CompletableFuture<Boolean[]> scriptExists(@NonNull String[] sha1s, @NonNull RequestRoutingConfiguration.Route route) {
        if (sha1s == null) {
            throw new NullPointerException("sha1s is marked non-null but is null");
        }
        if (route == null) {
            throw new NullPointerException("route is marked non-null but is null");
        }
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.ScriptExists, sha1s, route, response -> ArrayTransformUtils.castArray(this.handleArrayResponse((ResponseOuterClass.Response)response), Boolean.class));
    }

    @Override
    public CompletableFuture<Boolean[]> scriptExists(@NonNull GlideString[] sha1s, @NonNull RequestRoutingConfiguration.Route route) {
        if (sha1s == null) {
            throw new NullPointerException("sha1s is marked non-null but is null");
        }
        if (route == null) {
            throw new NullPointerException("route is marked non-null but is null");
        }
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.ScriptExists, sha1s, route, response -> ArrayTransformUtils.castArray(this.handleArrayResponse((ResponseOuterClass.Response)response), Boolean.class));
    }

    @Override
    public CompletableFuture<String> scriptFlush() {
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.ScriptFlush, new String[0], this::handleStringResponse);
    }

    @Override
    public CompletableFuture<String> scriptFlush(@NonNull FlushMode flushMode) {
        if (flushMode == null) {
            throw new NullPointerException("flushMode is marked non-null but is null");
        }
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.ScriptFlush, new String[]{flushMode.toString()}, this::handleStringResponse);
    }

    @Override
    public CompletableFuture<String> scriptFlush(@NonNull RequestRoutingConfiguration.Route route) {
        if (route == null) {
            throw new NullPointerException("route is marked non-null but is null");
        }
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.ScriptFlush, new String[0], route, this::handleStringResponse);
    }

    @Override
    public CompletableFuture<String> scriptFlush(@NonNull FlushMode flushMode, @NonNull RequestRoutingConfiguration.Route route) {
        if (flushMode == null) {
            throw new NullPointerException("flushMode is marked non-null but is null");
        }
        if (route == null) {
            throw new NullPointerException("route is marked non-null but is null");
        }
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.ScriptFlush, new String[]{flushMode.toString()}, route, this::handleStringResponse);
    }

    @Override
    public CompletableFuture<String> scriptKill() {
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.ScriptKill, new String[0], this::handleStringResponse);
    }

    @Override
    public CompletableFuture<String> scriptKill(@NonNull RequestRoutingConfiguration.Route route) {
        if (route == null) {
            throw new NullPointerException("route is marked non-null but is null");
        }
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.ScriptKill, new String[0], route, this::handleStringResponse);
    }

    @Override
    public CompletableFuture<ClusterValue<Map<String, Map<String, Object>>>> functionStats() {
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.FunctionStats, new String[0], response -> this.handleFunctionStatsResponse((ResponseOuterClass.Response)response, false));
    }

    @Override
    public CompletableFuture<ClusterValue<Map<GlideString, Map<GlideString, Object>>>> functionStatsBinary() {
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.FunctionStats, new GlideString[0], response -> this.handleFunctionStatsBinaryResponse((ResponseOuterClass.Response)response, false));
    }

    @Override
    public CompletableFuture<ClusterValue<Map<String, Map<String, Object>>>> functionStats(@NonNull RequestRoutingConfiguration.Route route) {
        if (route == null) {
            throw new NullPointerException("route is marked non-null but is null");
        }
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.FunctionStats, new String[0], route, response -> this.handleFunctionStatsResponse((ResponseOuterClass.Response)response, route instanceof RequestRoutingConfiguration.SingleNodeRoute));
    }

    @Override
    public CompletableFuture<ClusterValue<Map<GlideString, Map<GlideString, Object>>>> functionStatsBinary(@NonNull RequestRoutingConfiguration.Route route) {
        if (route == null) {
            throw new NullPointerException("route is marked non-null but is null");
        }
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.FunctionStats, new GlideString[0], route, response -> this.handleFunctionStatsBinaryResponse((ResponseOuterClass.Response)response, route instanceof RequestRoutingConfiguration.SingleNodeRoute));
    }

    @Override
    public CompletableFuture<String> publish(@NonNull String message, @NonNull String channel, boolean sharded) {
        if (message == null) {
            throw new NullPointerException("message is marked non-null but is null");
        }
        if (channel == null) {
            throw new NullPointerException("channel is marked non-null but is null");
        }
        if (!sharded) {
            return this.publish(message, channel);
        }
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.SPublish, new String[]{channel, message}, response -> {
            this.handleLongResponse((ResponseOuterClass.Response)response);
            return OK;
        });
    }

    @Override
    public CompletableFuture<String> publish(@NonNull GlideString message, @NonNull GlideString channel, boolean sharded) {
        if (message == null) {
            throw new NullPointerException("message is marked non-null but is null");
        }
        if (channel == null) {
            throw new NullPointerException("channel is marked non-null but is null");
        }
        if (!sharded) {
            return this.publish(message, channel);
        }
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.SPublish, new GlideString[]{channel, message}, response -> {
            this.handleLongResponse((ResponseOuterClass.Response)response);
            return OK;
        });
    }

    @Override
    public CompletableFuture<String[]> pubsubShardChannels() {
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.PubSubShardChannels, new String[0], response -> ArrayTransformUtils.castArray(this.handleArrayResponse((ResponseOuterClass.Response)response), String.class));
    }

    @Override
    public CompletableFuture<GlideString[]> pubsubShardChannelsBinary() {
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.PubSubShardChannels, new GlideString[0], response -> ArrayTransformUtils.castArray(this.handleArrayResponseBinary((ResponseOuterClass.Response)response), GlideString.class));
    }

    @Override
    public CompletableFuture<String[]> pubsubShardChannels(@NonNull String pattern) {
        if (pattern == null) {
            throw new NullPointerException("pattern is marked non-null but is null");
        }
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.PubSubShardChannels, new String[]{pattern}, response -> ArrayTransformUtils.castArray(this.handleArrayResponse((ResponseOuterClass.Response)response), String.class));
    }

    @Override
    public CompletableFuture<GlideString[]> pubsubShardChannels(@NonNull GlideString pattern) {
        if (pattern == null) {
            throw new NullPointerException("pattern is marked non-null but is null");
        }
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.PubSubShardChannels, new GlideString[]{pattern}, response -> ArrayTransformUtils.castArray(this.handleArrayResponseBinary((ResponseOuterClass.Response)response), GlideString.class));
    }

    @Override
    public CompletableFuture<Map<String, Long>> pubsubShardNumSub(@NonNull String[] channels) {
        if (channels == null) {
            throw new NullPointerException("channels is marked non-null but is null");
        }
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.PubSubShardNumSub, channels, this::handleMapResponse);
    }

    @Override
    public CompletableFuture<Map<GlideString, Long>> pubsubShardNumSub(@NonNull GlideString[] channels) {
        if (channels == null) {
            throw new NullPointerException("channels is marked non-null but is null");
        }
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.PubSubShardNumSub, channels, this::handleBinaryStringMapResponse);
    }

    @Override
    public CompletableFuture<String> unwatch(@NonNull RequestRoutingConfiguration.Route route) {
        if (route == null) {
            throw new NullPointerException("route is marked non-null but is null");
        }
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.UnWatch, new String[0], route, this::handleStringResponse);
    }

    @Override
    public CompletableFuture<String> unwatch() {
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.UnWatch, new String[0], this::handleStringResponse);
    }

    @Override
    public CompletableFuture<String> randomKey(@NonNull RequestRoutingConfiguration.Route route) {
        if (route == null) {
            throw new NullPointerException("route is marked non-null but is null");
        }
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.RandomKey, new String[0], route, this::handleStringOrNullResponse);
    }

    @Override
    public CompletableFuture<GlideString> randomKeyBinary(@NonNull RequestRoutingConfiguration.Route route) {
        if (route == null) {
            throw new NullPointerException("route is marked non-null but is null");
        }
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.RandomKey, new GlideString[0], route, this::handleGlideStringOrNullResponse);
    }

    @Override
    public CompletableFuture<String> randomKey() {
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.RandomKey, new String[0], this::handleStringOrNullResponse);
    }

    @Override
    public CompletableFuture<GlideString> randomKeyBinary() {
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.RandomKey, new GlideString[0], this::handleGlideStringOrNullResponse);
    }

    /*
     * Exception decompiling
     */
    @Override
    public CompletableFuture<Object[]> scan(ClusterScanCursor cursor) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredReturn.rewriteExpressions(StructuredReturn.java:99)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Override
    public CompletableFuture<Object[]> scanBinary(ClusterScanCursor cursor) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredReturn.rewriteExpressions(StructuredReturn.java:99)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Override
    public CompletableFuture<Object[]> scan(ClusterScanCursor cursor, ScanOptions options) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredReturn.rewriteExpressions(StructuredReturn.java:99)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Override
    public CompletableFuture<Object[]> scanBinary(ClusterScanCursor cursor, ScanOptions options) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredReturn.rewriteExpressions(StructuredReturn.java:99)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static final class NativeClusterScanCursor
    implements CommandManager.ClusterScanCursorDetail {
        private final String cursorHandle;
        private final boolean isFinished;
        private boolean isClosed = false;

        public NativeClusterScanCursor(@NonNull String cursorHandle) {
            if (cursorHandle == null) {
                throw new NullPointerException("cursorHandle is marked non-null but is null");
            }
            this.cursorHandle = cursorHandle;
            this.isFinished = ClusterScanCursorResolver.FINISHED_CURSOR_HANDLE.equals(cursorHandle);
        }

        @Override
        public String getCursorHandle() {
            return this.cursorHandle;
        }

        @Override
        public boolean isFinished() {
            return this.isFinished;
        }

        @Override
        public void releaseCursorHandle() {
            this.internalClose();
        }

        protected void finalize() throws Throwable {
            try {
                this.internalClose();
            }
            finally {
                super.finalize();
            }
        }

        private void internalClose() {
            if (!this.isClosed) {
                try {
                    ClusterScanCursorResolver.releaseNativeCursor(this.cursorHandle);
                }
                catch (Exception ex) {
                    Logger.log(Logger.Level.ERROR, "ClusterScanCursor", () -> "Error releasing cursor " + this.cursorHandle, (Throwable)ex);
                }
                finally {
                    this.isClosed = true;
                }
            }
        }
    }
}

