/*
 * Decompiled with CFR 0.152.
 */
package glide.api.models.commands.FT;

import glide.api.models.GlideString;
import glide.api.models.commands.FT.FTAggregateOptions;
import glide.api.models.commands.FT.FTSearchOptions;
import glide.utils.ArrayTransformUtils;
import java.util.ArrayList;
import java.util.List;
import lombok.NonNull;

public class FTProfileOptions {
    private final QueryType queryType;
    private final boolean limited;
    private final GlideString[] commandLine;

    public FTProfileOptions(@NonNull String query, @NonNull FTAggregateOptions options) {
        this(GlideString.gs(query), options);
        if (query == null) {
            throw new NullPointerException("query is marked non-null but is null");
        }
        if (options == null) {
            throw new NullPointerException("options is marked non-null but is null");
        }
    }

    public FTProfileOptions(@NonNull GlideString query, @NonNull FTAggregateOptions options) {
        this(query, options, false);
        if (query == null) {
            throw new NullPointerException("query is marked non-null but is null");
        }
        if (options == null) {
            throw new NullPointerException("options is marked non-null but is null");
        }
    }

    public FTProfileOptions(@NonNull String query, @NonNull FTSearchOptions options) {
        this(GlideString.gs(query), options);
        if (query == null) {
            throw new NullPointerException("query is marked non-null but is null");
        }
        if (options == null) {
            throw new NullPointerException("options is marked non-null but is null");
        }
    }

    public FTProfileOptions(@NonNull GlideString query, @NonNull FTSearchOptions options) {
        this(query, options, false);
        if (query == null) {
            throw new NullPointerException("query is marked non-null but is null");
        }
        if (options == null) {
            throw new NullPointerException("options is marked non-null but is null");
        }
    }

    public FTProfileOptions(@NonNull String query, @NonNull FTAggregateOptions options, boolean limited) {
        this(GlideString.gs(query), options, limited);
        if (query == null) {
            throw new NullPointerException("query is marked non-null but is null");
        }
        if (options == null) {
            throw new NullPointerException("options is marked non-null but is null");
        }
    }

    public FTProfileOptions(@NonNull GlideString query, @NonNull FTAggregateOptions options, boolean limited) {
        if (query == null) {
            throw new NullPointerException("query is marked non-null but is null");
        }
        if (options == null) {
            throw new NullPointerException("options is marked non-null but is null");
        }
        this.queryType = QueryType.AGGREGATE;
        this.commandLine = ArrayTransformUtils.concatenateArrays({query}, options.toArgs());
        this.limited = limited;
    }

    public FTProfileOptions(@NonNull String query, @NonNull FTSearchOptions options, boolean limited) {
        this(GlideString.gs(query), options, limited);
        if (query == null) {
            throw new NullPointerException("query is marked non-null but is null");
        }
        if (options == null) {
            throw new NullPointerException("options is marked non-null but is null");
        }
    }

    public FTProfileOptions(@NonNull GlideString query, @NonNull FTSearchOptions options, boolean limited) {
        if (query == null) {
            throw new NullPointerException("query is marked non-null but is null");
        }
        if (options == null) {
            throw new NullPointerException("options is marked non-null but is null");
        }
        this.queryType = QueryType.SEARCH;
        this.commandLine = ArrayTransformUtils.concatenateArrays({query}, options.toArgs());
        this.limited = limited;
    }

    public GlideString[] toArgs() {
        ArrayList<GlideString> args = new ArrayList<GlideString>();
        args.add(GlideString.gs(this.queryType.toString()));
        if (this.limited) {
            args.add(GlideString.gs("LIMITED"));
        }
        args.add(GlideString.gs("QUERY"));
        args.addAll(List.of(this.commandLine));
        return (GlideString[])args.toArray(GlideString[]::new);
    }

    static enum QueryType {
        SEARCH,
        AGGREGATE;

    }
}

