/*
 * Decompiled with CFR 0.152.
 */
package glide.api.models.commands.FT;

import glide.api.models.GlideString;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import lombok.NonNull;
import org.apache.commons.lang3.tuple.Pair;

public class FTSearchOptions {
    private final Map<GlideString, GlideString> identifiers;
    private final Integer timeout;
    private final Pair<Integer, Integer> limit;
    private final boolean count;
    private final Map<GlideString, GlideString> params;

    public GlideString[] toArgs() {
        ArrayList<GlideString> args = new ArrayList<GlideString>();
        if (!this.identifiers.isEmpty()) {
            args.add(GlideString.gs("RETURN"));
            int tokenCount = 0;
            for (Map.Entry<GlideString, GlideString> pair : this.identifiers.entrySet()) {
                ++tokenCount;
                args.add(pair.getKey());
                if (pair.getValue() == null) continue;
                tokenCount += 2;
                args.add(GlideString.gs("AS"));
                args.add(pair.getValue());
            }
            args.add(1, GlideString.gs(Integer.toString(tokenCount)));
        }
        if (this.timeout != null) {
            args.add(GlideString.gs("TIMEOUT"));
            args.add(GlideString.gs(this.timeout.toString()));
        }
        if (!this.params.isEmpty()) {
            args.add(GlideString.gs("PARAMS"));
            args.add(GlideString.gs(Integer.toString(this.params.size() * 2)));
            this.params.forEach((name, value) -> {
                args.add((GlideString)name);
                args.add((GlideString)value);
            });
        }
        if (this.limit != null) {
            args.add(GlideString.gs("LIMIT"));
            args.add(GlideString.gs(Integer.toString((Integer)this.limit.getLeft())));
            args.add(GlideString.gs(Integer.toString((Integer)this.limit.getRight())));
        }
        if (this.count) {
            args.add(GlideString.gs("COUNT"));
        }
        return (GlideString[])args.toArray(GlideString[]::new);
    }

    private static Map<GlideString, GlideString> $default$identifiers() {
        return new HashMap<GlideString, GlideString>();
    }

    private static boolean $default$count() {
        return false;
    }

    private static Map<GlideString, GlideString> $default$params() {
        return new HashMap<GlideString, GlideString>();
    }

    FTSearchOptions(Map<GlideString, GlideString> identifiers, Integer timeout, Pair<Integer, Integer> limit, boolean count, Map<GlideString, GlideString> params) {
        this.identifiers = identifiers;
        this.timeout = timeout;
        this.limit = limit;
        this.count = count;
        this.params = params;
    }

    public static FTSearchOptionsBuilder builder() {
        return new FTSearchOptionsBuilder();
    }

    public static class FTSearchOptionsBuilder {
        private boolean identifiers$set;
        private Map<GlideString, GlideString> identifiers$value;
        private Integer timeout;
        private Pair<Integer, Integer> limit;
        private boolean count$set;
        private boolean count$value;
        private boolean params$set;
        private Map<GlideString, GlideString> params$value;

        void limit(Pair<Integer, Integer> limit) {
        }

        void count(boolean count) {
        }

        void identifiers(Map<GlideString, GlideString> identifiers) {
        }

        public FTSearchOptionsBuilder addReturnField(@NonNull String field) {
            if (field == null) {
                throw new NullPointerException("field is marked non-null but is null");
            }
            this.identifiers$value.put(GlideString.gs(field), null);
            return this;
        }

        public FTSearchOptionsBuilder addReturnField(@NonNull String field, @NonNull String alias) {
            if (field == null) {
                throw new NullPointerException("field is marked non-null but is null");
            }
            if (alias == null) {
                throw new NullPointerException("alias is marked non-null but is null");
            }
            this.identifiers$value.put(GlideString.gs(field), GlideString.gs(alias));
            return this;
        }

        public FTSearchOptionsBuilder addReturnField(@NonNull GlideString field) {
            if (field == null) {
                throw new NullPointerException("field is marked non-null but is null");
            }
            this.identifiers$value.put(field, null);
            return this;
        }

        public FTSearchOptionsBuilder addReturnField(@NonNull GlideString field, @NonNull GlideString alias) {
            if (field == null) {
                throw new NullPointerException("field is marked non-null but is null");
            }
            if (alias == null) {
                throw new NullPointerException("alias is marked non-null but is null");
            }
            this.identifiers$value.put(field, alias);
            return this;
        }

        public FTSearchOptionsBuilder limit(int offset, int count) {
            this.limit = Pair.of((Object)offset, (Object)count);
            return this;
        }

        public FTSearchOptionsBuilder count() {
            this.count$value = true;
            this.count$set = true;
            return this;
        }

        FTSearchOptionsBuilder() {
        }

        public FTSearchOptionsBuilder timeout(Integer timeout) {
            this.timeout = timeout;
            return this;
        }

        public FTSearchOptionsBuilder params(Map<GlideString, GlideString> params) {
            this.params$value = params;
            this.params$set = true;
            return this;
        }

        public FTSearchOptions build() {
            Map<GlideString, GlideString> identifiers$value = this.identifiers$value;
            if (!this.identifiers$set) {
                identifiers$value = FTSearchOptions.$default$identifiers();
            }
            boolean count$value = this.count$value;
            if (!this.count$set) {
                count$value = FTSearchOptions.$default$count();
            }
            Map<GlideString, GlideString> params$value = this.params$value;
            if (!this.params$set) {
                params$value = FTSearchOptions.$default$params();
            }
            return new FTSearchOptions(identifiers$value, this.timeout, this.limit, count$value, params$value);
        }

        public String toString() {
            return "FTSearchOptions.FTSearchOptionsBuilder(identifiers$value=" + this.identifiers$value + ", timeout=" + this.timeout + ", limit=" + this.limit + ", count$value=" + this.count$value + ", params$value=" + this.params$value + ")";
        }
    }
}

