/*
 * Decompiled with CFR 0.152.
 */
package glide.api.models.commands;

import glide.api.models.GlideString;
import java.util.ArrayList;
import java.util.Arrays;

public class GetExOptions {
    private final ExpiryType type;
    private Long count;

    private GetExOptions(ExpiryType type) {
        this.type = type;
    }

    private GetExOptions(ExpiryType type, Long count) {
        this.type = type;
        this.count = count;
    }

    public static GetExOptions Seconds(Long seconds) {
        return new GetExOptions(ExpiryType.SECONDS, seconds);
    }

    public static GetExOptions Milliseconds(Long milliseconds) {
        return new GetExOptions(ExpiryType.MILLISECONDS, milliseconds);
    }

    public static GetExOptions UnixSeconds(Long unixSeconds) {
        return new GetExOptions(ExpiryType.UNIX_SECONDS, unixSeconds);
    }

    public static GetExOptions UnixMilliseconds(Long unixMilliseconds) {
        return new GetExOptions(ExpiryType.UNIX_MILLISECONDS, unixMilliseconds);
    }

    public static GetExOptions Persist() {
        return new GetExOptions(ExpiryType.PERSIST);
    }

    public String[] toArgs() {
        ArrayList<String> optionArgs = new ArrayList<String>();
        optionArgs.add(this.type.valkeyApi);
        if (this.count != null) {
            optionArgs.add(String.valueOf(this.count));
        }
        return optionArgs.toArray(new String[0]);
    }

    public GlideString[] toGlideStringArgs() {
        return (GlideString[])Arrays.stream(this.toArgs()).map(GlideString::gs).toArray(GlideString[]::new);
    }

    protected static enum ExpiryType {
        SECONDS("EX"),
        MILLISECONDS("PX"),
        UNIX_SECONDS("EXAT"),
        UNIX_MILLISECONDS("PXAT"),
        PERSIST("PERSIST");

        private final String valkeyApi;

        private ExpiryType(String valkeyApi) {
            this.valkeyApi = valkeyApi;
        }
    }
}

