/*
 * Decompiled with CFR 0.152.
 */
package glide.api.models.commands;

import glide.api.models.GlideString;
import glide.utils.ArgsBuilder;
import glide.utils.ArrayTransformUtils;
import lombok.NonNull;

public class RangeOptions {
    public static String[] createZRangeArgs(String key, RangeQuery rangeQuery, boolean reverse, boolean withScores) {
        String[] arguments = ArrayTransformUtils.concatenateArrays({key}, RangeOptions.createZRangeBaseArgs(rangeQuery, reverse, withScores));
        return arguments;
    }

    public static GlideString[] createZRangeArgsBinary(GlideString key, RangeQuery rangeQuery, boolean reverse, boolean withScores) {
        GlideString[] arguments = ArrayTransformUtils.concatenateArrays({key}, RangeOptions.createZRangeBaseArgsBinary(rangeQuery, reverse));
        if (withScores) {
            arguments = ArrayTransformUtils.concatenateArrays(arguments, {GlideString.gs("WITHSCORES")});
        }
        return arguments;
    }

    public static String[] createZRangeStoreArgs(String destination, String source, RangeQuery rangeQuery, boolean reverse) {
        return ArrayTransformUtils.concatenateArrays({destination, source}, RangeOptions.createZRangeBaseArgs(rangeQuery, reverse, false));
    }

    public static GlideString[] createZRangeStoreArgsBinary(GlideString destination, GlideString source, RangeQuery rangeQuery, boolean reverse) {
        return ArrayTransformUtils.concatenateArrays({destination, source}, RangeOptions.createZRangeBaseArgsBinary(rangeQuery, reverse));
    }

    public static String[] createZRangeBaseArgs(RangeQuery rangeQuery, boolean reverse, boolean withScores) {
        String[] arguments = new String[]{rangeQuery.getStart(), rangeQuery.getEnd()};
        if (rangeQuery instanceof RangeByScore) {
            arguments = ArrayTransformUtils.concatenateArrays(arguments, {"BYSCORE"});
        } else if (rangeQuery instanceof RangeByLex) {
            arguments = ArrayTransformUtils.concatenateArrays(arguments, {"BYLEX"});
        }
        if (reverse) {
            arguments = ArrayTransformUtils.concatenateArrays(arguments, {"REV"});
        }
        if (rangeQuery.getLimit() != null) {
            arguments = ArrayTransformUtils.concatenateArrays(arguments, {"LIMIT", Long.toString(rangeQuery.getLimit().getOffset()), Long.toString(rangeQuery.getLimit().getCount())});
        }
        if (withScores) {
            arguments = ArrayTransformUtils.concatenateArrays(arguments, {"WITHSCORES"});
        }
        return arguments;
    }

    public static GlideString[] createZRangeBaseArgsBinary(RangeQuery rangeQuery, boolean reverse) {
        ArgsBuilder builder = new ArgsBuilder().add(rangeQuery.getStart()).add(rangeQuery.getEnd());
        builder.addIf("BYSCORE", rangeQuery instanceof RangeByScore).addIf("BYLEX", rangeQuery instanceof RangeByLex).addIf("REV", reverse);
        if (rangeQuery.getLimit() != null) {
            builder.add("LIMIT").add(rangeQuery.getLimit().getOffset()).add(rangeQuery.getLimit().getCount());
        }
        return builder.toArray();
    }

    public static class RangeByScore
    implements ScoredRangeQuery {
        private final String start;
        private final String end;
        private final Limit limit;

        public RangeByScore(@NonNull ScoreRange start, @NonNull ScoreRange end, @NonNull Limit limit) {
            if (start == null) {
                throw new NullPointerException("start is marked non-null but is null");
            }
            if (end == null) {
                throw new NullPointerException("end is marked non-null but is null");
            }
            if (limit == null) {
                throw new NullPointerException("limit is marked non-null but is null");
            }
            this.start = start.toArgs();
            this.end = end.toArgs();
            this.limit = limit;
        }

        public RangeByScore(@NonNull ScoreRange start, @NonNull ScoreRange end) {
            if (start == null) {
                throw new NullPointerException("start is marked non-null but is null");
            }
            if (end == null) {
                throw new NullPointerException("end is marked non-null but is null");
            }
            this.start = start.toArgs();
            this.end = end.toArgs();
            this.limit = null;
        }

        @Override
        public String getStart() {
            return this.start;
        }

        @Override
        public String getEnd() {
            return this.end;
        }

        @Override
        public Limit getLimit() {
            return this.limit;
        }
    }

    public static class RangeByIndex
    implements ScoredRangeQuery {
        private final String start;
        private final String end;

        public RangeByIndex(long start, long end) {
            this.start = Long.toString(start);
            this.end = Long.toString(end);
        }

        @Override
        public Limit getLimit() {
            return null;
        }

        @Override
        public String getStart() {
            return this.start;
        }

        @Override
        public String getEnd() {
            return this.end;
        }
    }

    public static interface ScoredRangeQuery
    extends RangeQuery {
    }

    public static class RangeByLex
    implements RangeQuery {
        private final String start;
        private final String end;
        private final Limit limit;

        public RangeByLex(@NonNull LexRange start, @NonNull LexRange end, @NonNull Limit limit) {
            if (start == null) {
                throw new NullPointerException("start is marked non-null but is null");
            }
            if (end == null) {
                throw new NullPointerException("end is marked non-null but is null");
            }
            if (limit == null) {
                throw new NullPointerException("limit is marked non-null but is null");
            }
            this.start = start.toArgs();
            this.end = end.toArgs();
            this.limit = limit;
        }

        public RangeByLex(@NonNull LexRange start, @NonNull LexRange end) {
            if (start == null) {
                throw new NullPointerException("start is marked non-null but is null");
            }
            if (end == null) {
                throw new NullPointerException("end is marked non-null but is null");
            }
            this.start = start.toArgs();
            this.end = end.toArgs();
            this.limit = null;
        }

        @Override
        public String getStart() {
            return this.start;
        }

        @Override
        public String getEnd() {
            return this.end;
        }

        @Override
        public Limit getLimit() {
            return this.limit;
        }
    }

    public static interface RangeQuery {
        public String getStart();

        public String getEnd();

        public Limit getLimit();
    }

    public static class Limit {
        private final long offset;
        private final long count;

        public Limit(long offset, long count) {
            this.offset = offset;
            this.count = count;
        }

        public long getOffset() {
            return this.offset;
        }

        public long getCount() {
            return this.count;
        }
    }

    public static class LexBoundary
    implements LexRange {
        private final String value;
        private final boolean isInclusive;

        public LexBoundary(@NonNull String value, boolean isInclusive) {
            if (value == null) {
                throw new NullPointerException("value is marked non-null but is null");
            }
            this.value = value;
            this.isInclusive = isInclusive;
        }

        public LexBoundary(@NonNull String value) {
            this(value, true);
            if (value == null) {
                throw new NullPointerException("value is marked non-null but is null");
            }
        }

        @Override
        public String toArgs() {
            return (this.isInclusive ? "[" : "(") + this.value;
        }
    }

    public static enum InfLexBound implements LexRange
    {
        POSITIVE_INFINITY("+"),
        NEGATIVE_INFINITY("-");

        private final String valkeyApi;

        @Override
        public String toArgs() {
            return this.valkeyApi;
        }

        private InfLexBound(String valkeyApi) {
            this.valkeyApi = valkeyApi;
        }
    }

    public static interface LexRange {
        public String toArgs();
    }

    public static class ScoreBoundary
    implements ScoreRange {
        private final double bound;
        private final boolean isInclusive;

        public ScoreBoundary(double bound, boolean isInclusive) {
            this.bound = bound;
            this.isInclusive = isInclusive;
        }

        public ScoreBoundary(double bound) {
            this(bound, true);
        }

        @Override
        public String toArgs() {
            return (this.isInclusive ? "" : "(") + this.bound;
        }
    }

    public static enum InfScoreBound implements ScoreRange
    {
        POSITIVE_INFINITY("+inf"),
        NEGATIVE_INFINITY("-inf");

        private final String valkeyApi;

        @Override
        public String toArgs() {
            return this.valkeyApi;
        }

        private InfScoreBound(String valkeyApi) {
            this.valkeyApi = valkeyApi;
        }
    }

    public static interface ScoreRange {
        public String toArgs();
    }
}

