/*
 * Decompiled with CFR 0.152.
 */
package glide.api.models.commands;

import glide.api.models.commands.SortBaseOptions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class SortOptions
extends SortBaseOptions {
    public static final String BY_COMMAND_STRING = "BY";
    public static final String GET_COMMAND_STRING = "GET";
    private final String byPattern;
    private final List<String> getPatterns;

    @Override
    public String[] toArgs() {
        ArrayList<String> optionArgs = new ArrayList<String>(List.of(super.toArgs()));
        if (this.byPattern != null) {
            optionArgs.addAll(List.of(BY_COMMAND_STRING, this.byPattern));
        }
        if (this.getPatterns != null) {
            this.getPatterns.stream().forEach(getPattern -> optionArgs.addAll(List.of(GET_COMMAND_STRING, getPattern)));
        }
        return optionArgs.toArray(new String[0]);
    }

    protected SortOptions(SortOptionsBuilder<?, ?> b) {
        super(b);
        List<Object> getPatterns;
        this.byPattern = b.byPattern;
        switch (b.getPatterns == null ? 0 : b.getPatterns.size()) {
            case 0: {
                getPatterns = Collections.emptyList();
                break;
            }
            case 1: {
                getPatterns = Collections.singletonList(b.getPatterns.get(0));
                break;
            }
            default: {
                getPatterns = Collections.unmodifiableList(new ArrayList<String>(b.getPatterns));
            }
        }
        this.getPatterns = getPatterns;
    }

    public static SortOptionsBuilder<?, ?> builder() {
        return new SortOptionsBuilderImpl();
    }

    private static final class SortOptionsBuilderImpl
    extends SortOptionsBuilder<SortOptions, SortOptionsBuilderImpl> {
        private SortOptionsBuilderImpl() {
        }

        @Override
        protected SortOptionsBuilderImpl self() {
            return this;
        }

        @Override
        public SortOptions build() {
            return new SortOptions(this);
        }
    }

    public static abstract class SortOptionsBuilder<C extends SortOptions, B extends SortOptionsBuilder<C, B>>
    extends SortBaseOptions.SortBaseOptionsBuilder<C, B> {
        private String byPattern;
        private ArrayList<String> getPatterns;

        public B byPattern(String byPattern) {
            this.byPattern = byPattern;
            return (B)this.self();
        }

        public B getPattern(String getPattern) {
            if (this.getPatterns == null) {
                this.getPatterns = new ArrayList();
            }
            this.getPatterns.add(getPattern);
            return (B)this.self();
        }

        public B getPatterns(Collection<? extends String> getPatterns) {
            if (getPatterns == null) {
                throw new NullPointerException("getPatterns cannot be null");
            }
            if (this.getPatterns == null) {
                this.getPatterns = new ArrayList();
            }
            this.getPatterns.addAll(getPatterns);
            return (B)this.self();
        }

        public B clearGetPatterns() {
            if (this.getPatterns != null) {
                this.getPatterns.clear();
            }
            return (B)this.self();
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        @Override
        public String toString() {
            return "SortOptions.SortOptionsBuilder(super=" + super.toString() + ", byPattern=" + this.byPattern + ", getPatterns=" + this.getPatterns + ")";
        }
    }
}

