/*
 * Decompiled with CFR 0.152.
 */
package glide.api.models.commands.stream;

import glide.api.models.commands.stream.StreamRange;
import java.util.ArrayList;

public class StreamPendingOptions {
    public static final String IDLE_TIME_VALKEY_API = "IDLE";
    private final Long minIdleTime;
    private final String consumer;

    public String[] toArgs(StreamRange start, StreamRange end, long count) {
        ArrayList<String> optionArgs = new ArrayList<String>();
        if (this.minIdleTime != null) {
            optionArgs.add(IDLE_TIME_VALKEY_API);
            optionArgs.add(Long.toString(this.minIdleTime));
        }
        optionArgs.add(start.getValkeyApi());
        optionArgs.add(end.getValkeyApi());
        optionArgs.add(Long.toString(count));
        if (this.consumer != null) {
            optionArgs.add(this.consumer);
        }
        return optionArgs.toArray(new String[0]);
    }

    StreamPendingOptions(Long minIdleTime, String consumer) {
        this.minIdleTime = minIdleTime;
        this.consumer = consumer;
    }

    public static StreamPendingOptionsBuilder builder() {
        return new StreamPendingOptionsBuilder();
    }

    public static class StreamPendingOptionsBuilder {
        private Long minIdleTime;
        private String consumer;

        StreamPendingOptionsBuilder() {
        }

        public StreamPendingOptionsBuilder minIdleTime(Long minIdleTime) {
            this.minIdleTime = minIdleTime;
            return this;
        }

        public StreamPendingOptionsBuilder consumer(String consumer) {
            this.consumer = consumer;
            return this;
        }

        public StreamPendingOptions build() {
            return new StreamPendingOptions(this.minIdleTime, this.consumer);
        }

        public String toString() {
            return "StreamPendingOptions.StreamPendingOptionsBuilder(minIdleTime=" + this.minIdleTime + ", consumer=" + this.consumer + ")";
        }
    }
}

