/*
 * Decompiled with CFR 0.152.
 */
package glide.api.models.commands.stream;

import glide.api.models.GlideString;
import glide.api.models.commands.stream.StreamReadOptions;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public final class StreamReadGroupOptions
extends StreamReadOptions {
    public static final String READ_GROUP_VALKEY_API = "GROUP";
    public static final String READ_NOACK_VALKEY_API = "NOACK";
    private boolean noack;

    public <ArgType> GlideString[] toArgs(ArgType group, ArgType consumer) {
        ArrayList<GlideString> optionArgs = new ArrayList<GlideString>();
        optionArgs.add(GlideString.of(READ_GROUP_VALKEY_API));
        optionArgs.add(GlideString.of(group));
        optionArgs.add(GlideString.of(consumer));
        if (this.count != null) {
            optionArgs.add(GlideString.of("COUNT"));
            optionArgs.add(GlideString.of(this.count.toString()));
        }
        if (this.block != null) {
            optionArgs.add(GlideString.of("BLOCK"));
            optionArgs.add(GlideString.of(this.block.toString()));
        }
        if (this.noack) {
            optionArgs.add(GlideString.of(READ_NOACK_VALKEY_API));
        }
        optionArgs.add(GlideString.of("STREAMS"));
        return optionArgs.toArray(new GlideString[0]);
    }

    public String[] toArgs(String group, String consumer, Map<String, String> streams) {
        ArrayList<String> optionArgs = new ArrayList<String>();
        optionArgs.add(READ_GROUP_VALKEY_API);
        optionArgs.add(group);
        optionArgs.add(consumer);
        if (this.count != null) {
            optionArgs.add("COUNT");
            optionArgs.add(this.count.toString());
        }
        if (this.block != null) {
            optionArgs.add("BLOCK");
            optionArgs.add(this.block.toString());
        }
        if (this.noack) {
            optionArgs.add(READ_NOACK_VALKEY_API);
        }
        optionArgs.add("STREAMS");
        Set<Map.Entry<String, String>> entrySet = streams.entrySet();
        optionArgs.addAll(entrySet.stream().map(Map.Entry::getKey).collect(Collectors.toList()));
        optionArgs.addAll(entrySet.stream().map(Map.Entry::getValue).collect(Collectors.toList()));
        return optionArgs.toArray(new String[0]);
    }

    public GlideString[] toArgsBinary(GlideString group, GlideString consumer, Map<GlideString, GlideString> streams) {
        ArrayList<GlideString> optionArgs = new ArrayList<GlideString>();
        optionArgs.add(GlideString.gs(READ_GROUP_VALKEY_API));
        optionArgs.add(group);
        optionArgs.add(consumer);
        if (this.count != null) {
            optionArgs.add(GlideString.gs("COUNT"));
            optionArgs.add(GlideString.gs(this.count.toString()));
        }
        if (this.block != null) {
            optionArgs.add(GlideString.gs("BLOCK"));
            optionArgs.add(GlideString.gs(this.block.toString()));
        }
        if (this.noack) {
            optionArgs.add(GlideString.gs(READ_NOACK_VALKEY_API));
        }
        optionArgs.add(GlideString.gs("STREAMS"));
        Set<Map.Entry<GlideString, GlideString>> entrySet = streams.entrySet();
        optionArgs.addAll(entrySet.stream().map(Map.Entry::getKey).collect(Collectors.toList()));
        optionArgs.addAll(entrySet.stream().map(Map.Entry::getValue).collect(Collectors.toList()));
        return optionArgs.toArray(new GlideString[0]);
    }

    protected StreamReadGroupOptions(StreamReadGroupOptionsBuilder<?, ?> b) {
        super(b);
        this.noack = b.noack;
    }

    public static StreamReadGroupOptionsBuilder<?, ?> builder() {
        return new StreamReadGroupOptionsBuilderImpl();
    }

    private static final class StreamReadGroupOptionsBuilderImpl
    extends StreamReadGroupOptionsBuilder<StreamReadGroupOptions, StreamReadGroupOptionsBuilderImpl> {
        private StreamReadGroupOptionsBuilderImpl() {
        }

        @Override
        protected StreamReadGroupOptionsBuilderImpl self() {
            return this;
        }

        @Override
        public StreamReadGroupOptions build() {
            return new StreamReadGroupOptions(this);
        }
    }

    public static abstract class StreamReadGroupOptionsBuilder<C extends StreamReadGroupOptions, B extends StreamReadGroupOptionsBuilder<C, B>>
    extends StreamReadOptions.StreamReadOptionsBuilder<C, B> {
        private boolean noack;

        public B noack() {
            this.noack = true;
            return (B)this.self();
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        @Override
        public String toString() {
            return "StreamReadGroupOptions.StreamReadGroupOptionsBuilder(super=" + super.toString() + ", noack=" + this.noack + ")";
        }
    }
}

