/*
 * Decompiled with CFR 0.152.
 */
package glide.api.models.commands.stream;

import glide.api.models.GlideString;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class StreamReadOptions {
    public static final String READ_COUNT_VALKEY_API = "COUNT";
    public static final String READ_BLOCK_VALKEY_API = "BLOCK";
    public static final String READ_STREAMS_VALKEY_API = "STREAMS";
    protected Long block;
    protected Long count;

    public String[] toArgs(Map<String, String> streams) {
        ArrayList<String> optionArgs = new ArrayList<String>();
        if (this.count != null) {
            optionArgs.add(READ_COUNT_VALKEY_API);
            optionArgs.add(this.count.toString());
        }
        if (this.block != null) {
            optionArgs.add(READ_BLOCK_VALKEY_API);
            optionArgs.add(this.block.toString());
        }
        optionArgs.add(READ_STREAMS_VALKEY_API);
        Set<Map.Entry<String, String>> entrySet = streams.entrySet();
        optionArgs.addAll(entrySet.stream().map(Map.Entry::getKey).collect(Collectors.toList()));
        optionArgs.addAll(entrySet.stream().map(Map.Entry::getValue).collect(Collectors.toList()));
        return optionArgs.toArray(new String[0]);
    }

    public GlideString[] toArgsBinary(Map<GlideString, GlideString> streams) {
        ArrayList<GlideString> optionArgs = new ArrayList<GlideString>();
        if (this.count != null) {
            optionArgs.add(GlideString.gs(READ_COUNT_VALKEY_API));
            optionArgs.add(GlideString.gs(this.count.toString()));
        }
        if (this.block != null) {
            optionArgs.add(GlideString.gs(READ_BLOCK_VALKEY_API));
            optionArgs.add(GlideString.gs(this.block.toString()));
        }
        optionArgs.add(GlideString.gs(READ_STREAMS_VALKEY_API));
        Set<Map.Entry<GlideString, GlideString>> entrySet = streams.entrySet();
        optionArgs.addAll(entrySet.stream().map(Map.Entry::getKey).collect(Collectors.toList()));
        optionArgs.addAll(entrySet.stream().map(Map.Entry::getValue).collect(Collectors.toList()));
        return optionArgs.toArray(new GlideString[0]);
    }

    public String[] toArgs() {
        HashMap<String, String> emptyMap = new HashMap<String, String>();
        return this.toArgs(emptyMap);
    }

    public GlideString[] toArgsBinary() {
        HashMap<GlideString, GlideString> emptyMap = new HashMap<GlideString, GlideString>();
        return this.toArgsBinary(emptyMap);
    }

    protected StreamReadOptions(StreamReadOptionsBuilder<?, ?> b) {
        this.block = b.block;
        this.count = b.count;
    }

    public static StreamReadOptionsBuilder<?, ?> builder() {
        return new StreamReadOptionsBuilderImpl();
    }

    private static final class StreamReadOptionsBuilderImpl
    extends StreamReadOptionsBuilder<StreamReadOptions, StreamReadOptionsBuilderImpl> {
        private StreamReadOptionsBuilderImpl() {
        }

        @Override
        protected StreamReadOptionsBuilderImpl self() {
            return this;
        }

        @Override
        public StreamReadOptions build() {
            return new StreamReadOptions(this);
        }
    }

    public static abstract class StreamReadOptionsBuilder<C extends StreamReadOptions, B extends StreamReadOptionsBuilder<C, B>> {
        private Long block;
        private Long count;

        public B block(Long block) {
            this.block = block;
            return this.self();
        }

        public B count(Long count) {
            this.count = count;
            return this.self();
        }

        protected abstract B self();

        public abstract C build();

        public String toString() {
            return "StreamReadOptions.StreamReadOptionsBuilder(block=" + this.block + ", count=" + this.count + ")";
        }
    }
}

