/*
 * Decompiled with CFR 0.152.
 */
package glide.api.models.configuration;

import glide.api.models.configuration.BaseSubscriptionConfiguration;
import glide.api.models.configuration.NodeAddress;
import glide.api.models.configuration.ProtocolVersion;
import glide.api.models.configuration.ReadFrom;
import glide.api.models.configuration.ServerCredentials;
import glide.connectors.resources.ThreadPoolResource;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import lombok.NonNull;

public abstract class BaseClientConfiguration {
    private final List<NodeAddress> addresses;
    private final boolean useTLS;
    @NonNull
    private final ReadFrom readFrom;
    private final ServerCredentials credentials;
    private final Integer requestTimeout;
    private final String clientName;
    private final ThreadPoolResource threadPoolResource;
    private final ProtocolVersion protocol;
    private final Integer inflightRequestsLimit;
    private final String clientAZ;

    public abstract BaseSubscriptionConfiguration getSubscriptionConfiguration();

    private static boolean $default$useTLS() {
        return false;
    }

    private static ReadFrom $default$readFrom() {
        return ReadFrom.PRIMARY;
    }

    protected BaseClientConfiguration(BaseClientConfigurationBuilder<?, ?> b) {
        List<Object> addresses;
        switch (b.addresses == null ? 0 : b.addresses.size()) {
            case 0: {
                addresses = Collections.emptyList();
                break;
            }
            case 1: {
                addresses = Collections.singletonList(b.addresses.get(0));
                break;
            }
            default: {
                addresses = Collections.unmodifiableList(new ArrayList<NodeAddress>(b.addresses));
            }
        }
        this.addresses = addresses;
        this.useTLS = b.useTLS$set ? b.useTLS$value : BaseClientConfiguration.$default$useTLS();
        this.readFrom = b.readFrom$set ? b.readFrom$value : BaseClientConfiguration.$default$readFrom();
        if (this.readFrom == null) {
            throw new NullPointerException("readFrom is marked non-null but is null");
        }
        this.credentials = b.credentials;
        this.requestTimeout = b.requestTimeout;
        this.clientName = b.clientName;
        this.threadPoolResource = b.threadPoolResource;
        this.protocol = b.protocol;
        this.inflightRequestsLimit = b.inflightRequestsLimit;
        this.clientAZ = b.clientAZ;
    }

    public List<NodeAddress> getAddresses() {
        return this.addresses;
    }

    public boolean isUseTLS() {
        return this.useTLS;
    }

    @NonNull
    public ReadFrom getReadFrom() {
        return this.readFrom;
    }

    public ServerCredentials getCredentials() {
        return this.credentials;
    }

    public Integer getRequestTimeout() {
        return this.requestTimeout;
    }

    public String getClientName() {
        return this.clientName;
    }

    public ThreadPoolResource getThreadPoolResource() {
        return this.threadPoolResource;
    }

    public ProtocolVersion getProtocol() {
        return this.protocol;
    }

    public Integer getInflightRequestsLimit() {
        return this.inflightRequestsLimit;
    }

    public String getClientAZ() {
        return this.clientAZ;
    }

    public static abstract class BaseClientConfigurationBuilder<C extends BaseClientConfiguration, B extends BaseClientConfigurationBuilder<C, B>> {
        private ArrayList<NodeAddress> addresses;
        private boolean useTLS$set;
        private boolean useTLS$value;
        private boolean readFrom$set;
        private ReadFrom readFrom$value;
        private ServerCredentials credentials;
        private Integer requestTimeout;
        private String clientName;
        private ThreadPoolResource threadPoolResource;
        private ProtocolVersion protocol;
        private Integer inflightRequestsLimit;
        private String clientAZ;

        public B address(NodeAddress address) {
            if (this.addresses == null) {
                this.addresses = new ArrayList();
            }
            this.addresses.add(address);
            return this.self();
        }

        public B addresses(Collection<? extends NodeAddress> addresses) {
            if (addresses == null) {
                throw new NullPointerException("addresses cannot be null");
            }
            if (this.addresses == null) {
                this.addresses = new ArrayList();
            }
            this.addresses.addAll(addresses);
            return this.self();
        }

        public B clearAddresses() {
            if (this.addresses != null) {
                this.addresses.clear();
            }
            return this.self();
        }

        public B useTLS(boolean useTLS) {
            this.useTLS$value = useTLS;
            this.useTLS$set = true;
            return this.self();
        }

        public B readFrom(@NonNull ReadFrom readFrom) {
            if (readFrom == null) {
                throw new NullPointerException("readFrom is marked non-null but is null");
            }
            this.readFrom$value = readFrom;
            this.readFrom$set = true;
            return this.self();
        }

        public B credentials(ServerCredentials credentials) {
            this.credentials = credentials;
            return this.self();
        }

        public B requestTimeout(Integer requestTimeout) {
            this.requestTimeout = requestTimeout;
            return this.self();
        }

        public B clientName(String clientName) {
            this.clientName = clientName;
            return this.self();
        }

        public B threadPoolResource(ThreadPoolResource threadPoolResource) {
            this.threadPoolResource = threadPoolResource;
            return this.self();
        }

        public B protocol(ProtocolVersion protocol) {
            this.protocol = protocol;
            return this.self();
        }

        public B inflightRequestsLimit(Integer inflightRequestsLimit) {
            this.inflightRequestsLimit = inflightRequestsLimit;
            return this.self();
        }

        public B clientAZ(String clientAZ) {
            this.clientAZ = clientAZ;
            return this.self();
        }

        protected abstract B self();

        public abstract C build();

        public String toString() {
            return "BaseClientConfiguration.BaseClientConfigurationBuilder(addresses=" + this.addresses + ", useTLS$value=" + this.useTLS$value + ", readFrom$value=" + this.readFrom$value + ", credentials=" + this.credentials + ", requestTimeout=" + this.requestTimeout + ", clientName=" + this.clientName + ", threadPoolResource=" + this.threadPoolResource + ", protocol=" + this.protocol + ", inflightRequestsLimit=" + this.inflightRequestsLimit + ", clientAZ=" + this.clientAZ + ")";
        }
    }
}

