/*
 * Decompiled with CFR 0.152.
 */
package glide.api.models.configuration;

import glide.api.models.exceptions.RequestException;
import lombok.NonNull;

public class RequestRoutingConfiguration {

    public static class ByAddressRoute
    implements SingleNodeRoute {
        private final String host;
        private final int port;

        public ByAddressRoute(@NonNull String host, int port) {
            if (host == null) {
                throw new NullPointerException("host is marked non-null but is null");
            }
            this.host = host;
            this.port = port;
        }

        public ByAddressRoute(@NonNull String host) {
            if (host == null) {
                throw new NullPointerException("host is marked non-null but is null");
            }
            String[] split = host.split(":");
            if (split.length < 2) {
                throw new RequestException("No port provided, and host is not in the expected format 'hostname:port'. Received: " + host);
            }
            this.host = split[0];
            try {
                this.port = Integer.parseInt(split[1]);
            }
            catch (NumberFormatException e) {
                throw new RequestException("Port must be a valid integer. Received: " + split[1]);
            }
        }

        public String getHost() {
            return this.host;
        }

        public int getPort() {
            return this.port;
        }
    }

    public static class SlotKeyRoute
    implements SingleNodeRoute {
        private final String slotKey;
        private final SlotType slotType;

        public SlotKeyRoute(String slotKey, SlotType slotType) {
            this.slotKey = slotKey;
            this.slotType = slotType;
        }

        public String getSlotKey() {
            return this.slotKey;
        }

        public SlotType getSlotType() {
            return this.slotType;
        }
    }

    public static class SlotIdRoute
    implements SingleNodeRoute {
        private final int slotId;
        private final SlotType slotType;

        public SlotIdRoute(int slotId, SlotType slotType) {
            this.slotId = slotId;
            this.slotType = slotType;
        }

        public int getSlotId() {
            return this.slotId;
        }

        public SlotType getSlotType() {
            return this.slotType;
        }
    }

    public static enum SlotType {
        PRIMARY,
        REPLICA;

    }

    public static enum SimpleMultiNodeRoute implements MultiNodeRoute
    {
        ALL_NODES(0),
        ALL_PRIMARIES(1);

        private final int ordinal;

        private SimpleMultiNodeRoute(int ordinal) {
            this.ordinal = ordinal;
        }

        public int getOrdinal() {
            return this.ordinal;
        }
    }

    public static enum SimpleSingleNodeRoute implements SingleNodeRoute
    {
        RANDOM(2);

        private final int ordinal;

        private SimpleSingleNodeRoute(int ordinal) {
            this.ordinal = ordinal;
        }

        public int getOrdinal() {
            return this.ordinal;
        }
    }

    public static interface MultiNodeRoute
    extends Route {
    }

    public static interface SingleNodeRoute
    extends Route {
    }

    public static interface Route {
    }
}

