/*
 * Decompiled with CFR 0.152.
 */
package glide.api.models.configuration;

import lombok.NonNull;

public class ServerCredentials {
    @NonNull
    private final String password;
    private final String username;

    ServerCredentials(@NonNull String password, String username) {
        if (password == null) {
            throw new NullPointerException("password is marked non-null but is null");
        }
        this.password = password;
        this.username = username;
    }

    public static ServerCredentialsBuilder builder() {
        return new ServerCredentialsBuilder();
    }

    @NonNull
    public String getPassword() {
        return this.password;
    }

    public String getUsername() {
        return this.username;
    }

    public static class ServerCredentialsBuilder {
        private String password;
        private String username;

        ServerCredentialsBuilder() {
        }

        public ServerCredentialsBuilder password(@NonNull String password) {
            if (password == null) {
                throw new NullPointerException("password is marked non-null but is null");
            }
            this.password = password;
            return this;
        }

        public ServerCredentialsBuilder username(String username) {
            this.username = username;
            return this;
        }

        public ServerCredentials build() {
            return new ServerCredentials(this.password, this.username);
        }

        public String toString() {
            return "ServerCredentials.ServerCredentialsBuilder(password=" + this.password + ", username=" + this.username + ")";
        }
    }
}

