/*
 * Decompiled with CFR 0.152.
 */
package glide.api.models.configuration;

import glide.api.models.GlideString;
import glide.api.models.configuration.BaseSubscriptionConfiguration;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public final class StandaloneSubscriptionConfiguration
extends BaseSubscriptionConfiguration {
    private final Map<PubSubChannelMode, Set<GlideString>> subscriptions;

    public StandaloneSubscriptionConfiguration(Optional<BaseSubscriptionConfiguration.MessageCallback> callback, Optional<Object> context, Map<PubSubChannelMode, Set<GlideString>> subscriptions) {
        super(callback, context);
        this.subscriptions = subscriptions;
    }

    public static StandaloneSubscriptionConfigurationBuilder builder() {
        return new StandaloneSubscriptionConfigurationBuilder();
    }

    public Map<PubSubChannelMode, Set<GlideString>> getSubscriptions() {
        return this.subscriptions;
    }

    public static final class StandaloneSubscriptionConfigurationBuilder
    extends BaseSubscriptionConfiguration.BaseSubscriptionConfigurationBuilder<StandaloneSubscriptionConfigurationBuilder, StandaloneSubscriptionConfiguration> {
        private Map<PubSubChannelMode, Set<GlideString>> subscriptions = new LinkedHashMap<PubSubChannelMode, Set<GlideString>>(2);

        private StandaloneSubscriptionConfigurationBuilder() {
        }

        public StandaloneSubscriptionConfigurationBuilder subscription(PubSubChannelMode mode, GlideString channelOrPattern) {
            this.addSubscription(this.subscriptions, mode, channelOrPattern);
            return this.self();
        }

        public StandaloneSubscriptionConfigurationBuilder subscriptions(Map<PubSubChannelMode, Set<GlideString>> subscriptions) {
            this.subscriptions = subscriptions;
            return this;
        }

        public StandaloneSubscriptionConfigurationBuilder subscriptions(PubSubChannelMode mode, Set<GlideString> subscriptions) {
            this.subscriptions.put(mode, subscriptions);
            return this;
        }

        @Override
        protected StandaloneSubscriptionConfigurationBuilder self() {
            return this;
        }

        @Override
        public StandaloneSubscriptionConfiguration build() {
            return new StandaloneSubscriptionConfiguration(this.callback, this.context, this.subscriptions);
        }
    }

    public static enum PubSubChannelMode implements BaseSubscriptionConfiguration.ChannelMode
    {
        EXACT,
        PATTERN;

    }
}

