/*
 * Decompiled with CFR 0.152.
 */
package glide.connectors.handlers;

import glide.api.logging.Logger;
import glide.api.models.GlideString;
import glide.api.models.PubSubMessage;
import glide.api.models.configuration.BaseSubscriptionConfiguration;
import glide.api.models.exceptions.GlideException;
import glide.managers.BaseResponseResolver;
import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.stream.Collectors;
import response.ResponseOuterClass;

public class MessageHandler {
    private final Optional<BaseSubscriptionConfiguration.MessageCallback> callback;
    private final Optional<Object> context;
    private final BaseResponseResolver responseResolver;
    private final PubSubMessageQueue queue = new PubSubMessageQueue();

    void handle(ResponseOuterClass.Response response) throws MessageCallbackException {
        Object data = this.responseResolver.apply(response);
        if (!(data instanceof Map)) {
            Logger.log(Logger.Level.WARN, "invalid push", "Received invalid push: empty or in incorrect format.");
            throw new GlideException("Received invalid push: empty or in incorrect format.");
        }
        Map push = (Map)data;
        PushKind pushType = Enum.valueOf(PushKind.class, push.get("kind").toString());
        Object[] values = (Object[])push.get("values");
        switch (pushType) {
            case Disconnection: {
                Logger.log(Logger.Level.WARN, "disconnect notification", "Transport disconnected, messages might be lost");
                break;
            }
            case PMessage: {
                this.handle(new PubSubMessage(GlideString.gs((byte[])values[2]), GlideString.gs((byte[])values[1]), GlideString.gs((byte[])values[0])));
                return;
            }
            case Message: 
            case SMessage: {
                this.handle(new PubSubMessage(GlideString.gs((byte[])values[1]), GlideString.gs((byte[])values[0])));
                return;
            }
            case Subscribe: 
            case PSubscribe: 
            case SSubscribe: 
            case Unsubscribe: 
            case PUnsubscribe: 
            case SUnsubscribe: {
                Logger.log(Logger.Level.INFO, "subscribe/unsubscribe notification", () -> String.format("Received push notification of type '%s': %s", new Object[]{pushType, Arrays.stream(values).map(v -> GlideString.of(v).toString()).collect(Collectors.joining(" "))}));
                break;
            }
            default: {
                Logger.log(Logger.Level.WARN, "unknown notification", () -> String.format("Unknown notification message: '%s'", new Object[]{pushType}));
            }
        }
    }

    private void handle(PubSubMessage message) throws MessageCallbackException {
        if (this.callback.isPresent()) {
            try {
                this.callback.get().accept(message, this.context.orElse(null));
            }
            catch (Exception callbackException) {
                throw new MessageCallbackException(callbackException);
            }
        } else {
            this.queue.push(message);
        }
    }

    public Optional<BaseSubscriptionConfiguration.MessageCallback> getCallback() {
        return this.callback;
    }

    public Optional<Object> getContext() {
        return this.context;
    }

    public BaseResponseResolver getResponseResolver() {
        return this.responseResolver;
    }

    public MessageHandler(Optional<BaseSubscriptionConfiguration.MessageCallback> callback, Optional<Object> context, BaseResponseResolver responseResolver) {
        this.callback = callback;
        this.context = context;
        this.responseResolver = responseResolver;
    }

    public PubSubMessageQueue getQueue() {
        return this.queue;
    }

    public static class PubSubMessageQueue {
        final ConcurrentLinkedDeque<PubSubMessage> messageQueue = new ConcurrentLinkedDeque();
        CompletableFuture<PubSubMessage> firstMessagePromise = new CompletableFuture();
        private boolean firstMessagePromiseRequested = false;
        private final Object lock = new Object();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void push(PubSubMessage message) {
            Object object = this.lock;
            synchronized (object) {
                if (this.firstMessagePromiseRequested) {
                    this.firstMessagePromiseRequested = false;
                    this.firstMessagePromise.complete(message);
                    this.firstMessagePromise = new CompletableFuture();
                    return;
                }
                this.messageQueue.addLast(message);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public CompletableFuture<PubSubMessage> popAsync() {
            Object object = this.lock;
            synchronized (object) {
                PubSubMessage message = this.messageQueue.poll();
                if (message == null) {
                    this.firstMessagePromiseRequested = true;
                    return this.firstMessagePromise;
                }
                CompletableFuture<PubSubMessage> future = new CompletableFuture<PubSubMessage>();
                future.complete(message);
                return future;
            }
        }

        public PubSubMessage popSync() {
            return this.messageQueue.poll();
        }
    }

    static enum PushKind {
        Disconnection,
        Other,
        Invalidate,
        Message,
        PMessage,
        SMessage,
        Unsubscribe,
        PUnsubscribe,
        SUnsubscribe,
        Subscribe,
        PSubscribe,
        SSubscribe;

    }

    static class MessageCallbackException
    extends Exception {
        private MessageCallbackException(Exception cause) {
            super(cause);
        }

        @Override
        public synchronized Exception getCause() {
            return (Exception)super.getCause();
        }
    }
}

