/*
 * Decompiled with CFR 0.152.
 */
package glide.connectors.handlers;

import glide.api.logging.Logger;
import glide.connectors.handlers.CallbackDispatcher;
import glide.connectors.handlers.MessageHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import lombok.NonNull;
import response.ResponseOuterClass;

public class ReadHandler
extends ChannelInboundHandlerAdapter {
    private final CallbackDispatcher callbackDispatcher;

    public void channelRead(@NonNull ChannelHandlerContext ctx, @NonNull Object msg) throws MessageHandler.MessageCallbackException {
        if (ctx == null) {
            throw new NullPointerException("ctx is marked non-null but is null");
        }
        if (msg == null) {
            throw new NullPointerException("msg is marked non-null but is null");
        }
        if (msg instanceof ResponseOuterClass.Response) {
            ResponseOuterClass.Response response = (ResponseOuterClass.Response)msg;
            this.callbackDispatcher.completeRequest(response);
            ctx.fireChannelRead(msg);
            return;
        }
        throw new RuntimeException("Unexpected message in socket");
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        if (cause instanceof MessageHandler.MessageCallbackException) {
            Logger.log(Logger.Level.ERROR, "read handler", () -> "=== Exception thrown from pubsub callback " + ctx, cause.getCause());
            cause.printStackTrace();
            throw ((MessageHandler.MessageCallbackException)cause).getCause();
        }
        Logger.log(Logger.Level.ERROR, "read handler", () -> "=== exceptionCaught " + ctx, cause);
        this.callbackDispatcher.distributeClosingException("An unhandled error while reading from UDS channel: " + cause);
    }

    public ReadHandler(CallbackDispatcher callbackDispatcher) {
        this.callbackDispatcher = callbackDispatcher;
    }
}

