/*
 * Decompiled with CFR 0.152.
 */
package io.valkey.mcf;

import io.github.resilience4j.circuitbreaker.CircuitBreaker;
import io.github.resilience4j.decorators.Decorators;
import io.valkey.CommandObject;
import io.valkey.Connection;
import io.valkey.annots.Experimental;
import io.valkey.executors.CommandExecutor;
import io.valkey.mcf.CircuitBreakerFailoverBase;
import io.valkey.providers.MultiClusterPooledConnectionProvider;

@Experimental
public class CircuitBreakerCommandExecutor
extends CircuitBreakerFailoverBase
implements CommandExecutor {
    public CircuitBreakerCommandExecutor(MultiClusterPooledConnectionProvider provider) {
        super(provider);
    }

    @Override
    public <T> T executeCommand(CommandObject<T> commandObject) {
        MultiClusterPooledConnectionProvider.Cluster cluster = this.provider.getCluster();
        Decorators.DecorateSupplier supplier = Decorators.ofSupplier(() -> this.handleExecuteCommand(commandObject, cluster));
        supplier.withRetry(cluster.getRetry());
        supplier.withCircuitBreaker(cluster.getCircuitBreaker());
        supplier.withFallback(this.provider.getFallbackExceptionList(), e -> this.handleClusterFailover(commandObject, cluster.getCircuitBreaker()));
        return supplier.decorate().get();
    }

    private <T> T handleExecuteCommand(CommandObject<T> commandObject, MultiClusterPooledConnectionProvider.Cluster cluster) {
        try (Connection connection = cluster.getConnection();){
            T t = connection.executeCommand(commandObject);
            return t;
        }
    }

    private <T> T handleClusterFailover(CommandObject<T> commandObject, CircuitBreaker circuitBreaker) {
        this.clusterFailover(circuitBreaker);
        return this.executeCommand(commandObject);
    }
}

