/*
 * Decompiled with CFR 0.152.
 */
package io.valkey.search.aggr;

import io.valkey.search.aggr.Reducer;
import io.valkey.search.aggr.SortedField;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class Reducers {
    public static Reducer count() {
        return new Reducer("COUNT"){

            @Override
            protected List<Object> getOwnArgs() {
                return Collections.emptyList();
            }
        };
    }

    private static Reducer singleFieldReducer(String name, String field) {
        return new Reducer(name, field){

            @Override
            protected List<Object> getOwnArgs() {
                return Collections.emptyList();
            }
        };
    }

    public static Reducer count_distinct(String field) {
        return Reducers.singleFieldReducer("COUNT_DISTINCT", field);
    }

    public static Reducer count_distinctish(String field) {
        return Reducers.singleFieldReducer("COUNT_DISTINCTISH", field);
    }

    public static Reducer sum(String field) {
        return Reducers.singleFieldReducer("SUM", field);
    }

    public static Reducer min(String field) {
        return Reducers.singleFieldReducer("MIN", field);
    }

    public static Reducer max(String field) {
        return Reducers.singleFieldReducer("MAX", field);
    }

    public static Reducer avg(String field) {
        return Reducers.singleFieldReducer("AVG", field);
    }

    public static Reducer stddev(String field) {
        return Reducers.singleFieldReducer("STDDEV", field);
    }

    public static Reducer quantile(String field, final double percentile) {
        return new Reducer("QUANTILE", field){

            @Override
            protected List<Object> getOwnArgs() {
                return Arrays.asList(percentile);
            }
        };
    }

    public static Reducer first_value(String field) {
        return Reducers.singleFieldReducer("FIRST_VALUE", field);
    }

    public static Reducer first_value(String field, final SortedField sortBy) {
        return new Reducer("FIRST_VALUE", field){

            @Override
            protected List<Object> getOwnArgs() {
                return Arrays.asList("BY", sortBy.getField(), sortBy.getOrder());
            }
        };
    }

    public static Reducer to_list(String field) {
        return Reducers.singleFieldReducer("TOLIST", field);
    }

    public static Reducer random_sample(String field, final int size) {
        return new Reducer("RANDOM_SAMPLE", field){

            @Override
            protected List<Object> getOwnArgs() {
                return Arrays.asList(size);
            }
        };
    }
}

