/*
 * Decompiled with CFR 0.152.
 */
package io.valkey;

import io.valkey.Connection;
import io.valkey.DefaultJedisClientConfig;
import io.valkey.DefaultJedisSocketFactory;
import io.valkey.HostAndPort;
import io.valkey.JedisClientConfig;
import io.valkey.JedisSocketFactory;
import io.valkey.exceptions.JedisException;
import org.apache.commons.pool2.PooledObject;
import org.apache.commons.pool2.PooledObjectFactory;
import org.apache.commons.pool2.impl.DefaultPooledObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectionFactory
implements PooledObjectFactory<Connection> {
    private static final Logger logger = LoggerFactory.getLogger(ConnectionFactory.class);
    private final JedisSocketFactory jedisSocketFactory;
    private final JedisClientConfig clientConfig;

    public ConnectionFactory(HostAndPort hostAndPort) {
        this.clientConfig = DefaultJedisClientConfig.builder().build();
        this.jedisSocketFactory = new DefaultJedisSocketFactory(hostAndPort);
    }

    public ConnectionFactory(HostAndPort hostAndPort, JedisClientConfig clientConfig) {
        this.clientConfig = DefaultJedisClientConfig.copyConfig(clientConfig);
        this.jedisSocketFactory = new DefaultJedisSocketFactory(hostAndPort, this.clientConfig);
    }

    public ConnectionFactory(JedisSocketFactory jedisSocketFactory, JedisClientConfig clientConfig) {
        this.clientConfig = DefaultJedisClientConfig.copyConfig(clientConfig);
        this.jedisSocketFactory = jedisSocketFactory;
    }

    public void activateObject(PooledObject<Connection> pooledConnection) throws Exception {
    }

    public void destroyObject(PooledObject<Connection> pooledConnection) throws Exception {
        Connection jedis = (Connection)pooledConnection.getObject();
        if (jedis.isConnected()) {
            try {
                jedis.close();
            }
            catch (RuntimeException e) {
                logger.debug("Error while close", (Throwable)e);
            }
        }
    }

    public PooledObject<Connection> makeObject() throws Exception {
        Connection jedis = null;
        try {
            jedis = new Connection(this.jedisSocketFactory, this.clientConfig);
            return new DefaultPooledObject((Object)jedis);
        }
        catch (JedisException je) {
            logger.debug("Error while makeObject", (Throwable)je);
            throw je;
        }
    }

    public void passivateObject(PooledObject<Connection> pooledConnection) throws Exception {
    }

    public boolean validateObject(PooledObject<Connection> pooledConnection) {
        Connection jedis = (Connection)pooledConnection.getObject();
        try {
            return jedis.isConnected() && jedis.ping();
        }
        catch (Exception e) {
            logger.warn("Error while validating pooled Connection object.", (Throwable)e);
            return false;
        }
    }
}

