/*
 * Decompiled with CFR 0.152.
 */
package io.valkey.mcf;

import io.github.resilience4j.circuitbreaker.CircuitBreaker;
import io.valkey.annots.Experimental;
import io.valkey.exceptions.JedisConnectionException;
import io.valkey.providers.MultiClusterPooledConnectionProvider;
import io.valkey.util.IOUtils;

@Experimental
public class CircuitBreakerFailoverBase
implements AutoCloseable {
    protected final MultiClusterPooledConnectionProvider provider;

    public CircuitBreakerFailoverBase(MultiClusterPooledConnectionProvider provider) {
        this.provider = provider;
    }

    @Override
    public void close() {
        IOUtils.closeQuietly(this.provider);
    }

    protected synchronized void clusterFailover(CircuitBreaker circuitBreaker) {
        if (!CircuitBreaker.State.FORCED_OPEN.equals((Object)circuitBreaker.getState())) {
            circuitBreaker.transitionToForcedOpenState();
            int activeMultiClusterIndex = this.provider.incrementActiveMultiClusterIndex();
            this.provider.runClusterFailoverPostProcessor(activeMultiClusterIndex);
        } else if (this.provider.isLastClusterCircuitBreakerForcedOpen()) {
            throw new JedisConnectionException("Cluster/database endpoint could not failover since the MultiClusterClientConfig was not provided with an additional cluster/database endpoint according to its prioritized sequence. If applicable, consider failing back OR restarting with an available cluster/database endpoint");
        }
    }
}

