/*
 * Decompiled with CFR 0.152.
 */
package io.valkey.graph;

import io.valkey.Builder;
import io.valkey.BuilderFactory;
import io.valkey.CommandArguments;
import io.valkey.CommandObject;
import io.valkey.Connection;
import io.valkey.commands.ProtocolCommand;
import io.valkey.graph.GraphCache;
import io.valkey.graph.GraphProtocol;
import io.valkey.graph.GraphQueryParams;
import io.valkey.graph.Record;
import io.valkey.graph.RedisGraphCommands;
import io.valkey.graph.ResultSet;
import io.valkey.graph.ResultSetBuilder;
import io.valkey.providers.ConnectionProvider;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Function;

@Deprecated
public class GraphCommandObjects {
    private final RedisGraphCommands graph;
    private final Connection connection;
    private final ConnectionProvider provider;
    private Function<ProtocolCommand, CommandArguments> commArgs = comm -> new CommandArguments((ProtocolCommand)comm);
    private final ConcurrentHashMap<String, Builder<ResultSet>> builders = new ConcurrentHashMap();

    public GraphCommandObjects(RedisGraphCommands graphCommands) {
        this.graph = graphCommands;
        this.connection = null;
        this.provider = null;
    }

    public GraphCommandObjects(Connection connection) {
        this.graph = null;
        this.connection = connection;
        this.provider = null;
    }

    public GraphCommandObjects(ConnectionProvider provider) {
        this.graph = null;
        this.connection = null;
        this.provider = provider;
    }

    public void setBaseCommandArgumentsCreator(Function<ProtocolCommand, CommandArguments> commArgs) {
        this.commArgs = commArgs;
    }

    public final CommandObject<ResultSet> graphQuery(String name, String query) {
        return new CommandObject<ResultSet>(this.commArgs.apply(GraphProtocol.GraphCommand.QUERY).key(name).add(query).add(GraphProtocol.GraphKeyword.__COMPACT), this.getBuilder(name));
    }

    public final CommandObject<ResultSet> graphReadonlyQuery(String name, String query) {
        return new CommandObject<ResultSet>(this.commArgs.apply(GraphProtocol.GraphCommand.RO_QUERY).key(name).add(query).add(GraphProtocol.GraphKeyword.__COMPACT), this.getBuilder(name));
    }

    public final CommandObject<ResultSet> graphQuery(String name, String query, long timeout) {
        return this.graphQuery(name, GraphQueryParams.queryParams(query).timeout(timeout));
    }

    public final CommandObject<ResultSet> graphReadonlyQuery(String name, String query, long timeout) {
        return this.graphQuery(name, GraphQueryParams.queryParams().readonly().query(query).timeout(timeout));
    }

    public final CommandObject<ResultSet> graphQuery(String name, String query, Map<String, Object> params) {
        return this.graphQuery(name, GraphQueryParams.queryParams(query).params(params));
    }

    public final CommandObject<ResultSet> graphReadonlyQuery(String name, String query, Map<String, Object> params) {
        return this.graphQuery(name, GraphQueryParams.queryParams().readonly().query(query).params(params));
    }

    public final CommandObject<ResultSet> graphQuery(String name, String query, Map<String, Object> params, long timeout) {
        return this.graphQuery(name, GraphQueryParams.queryParams(query).params(params).timeout(timeout));
    }

    public final CommandObject<ResultSet> graphReadonlyQuery(String name, String query, Map<String, Object> params, long timeout) {
        return this.graphQuery(name, GraphQueryParams.queryParams().readonly().query(query).params(params).timeout(timeout));
    }

    private CommandObject<ResultSet> graphQuery(String name, GraphQueryParams params) {
        return new CommandObject<ResultSet>(this.commArgs.apply(!params.isReadonly() ? GraphProtocol.GraphCommand.QUERY : GraphProtocol.GraphCommand.RO_QUERY).key(name).addParams(params), this.getBuilder(name));
    }

    public final CommandObject<String> graphDelete(String name) {
        return new CommandObject<String>(this.commArgs.apply(GraphProtocol.GraphCommand.DELETE).key(name), BuilderFactory.STRING);
    }

    private Builder<ResultSet> getBuilder(String graphName) {
        if (!this.builders.containsKey(graphName)) {
            this.createBuilder(graphName);
        }
        return this.builders.get(graphName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createBuilder(String graphName) {
        ConcurrentHashMap<String, Builder<ResultSet>> concurrentHashMap = this.builders;
        synchronized (concurrentHashMap) {
            this.builders.putIfAbsent(graphName, new ResultSetBuilder(new GraphCacheImpl(graphName)));
        }
    }

    private class GraphCacheList {
        private final String name;
        private final String query;
        private final List<String> data = new CopyOnWriteArrayList<String>();

        public GraphCacheList(String name, String procedure) {
            this.name = name;
            this.query = "CALL " + procedure + "()";
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String getCachedData(int index) {
            if (index >= this.data.size()) {
                List<String> list = this.data;
                synchronized (list) {
                    if (index >= this.data.size()) {
                        this.getProcedureInfo();
                    }
                }
            }
            return this.data.get(index);
        }

        private void getProcedureInfo() {
            ResultSet resultSet = this.callProcedure();
            Iterator it = resultSet.iterator();
            ArrayList<String> newData = new ArrayList<String>();
            int i = 0;
            while (it.hasNext()) {
                Record record = (Record)it.next();
                if (i >= this.data.size()) {
                    newData.add(record.getString(0));
                }
                ++i;
            }
            this.data.addAll(newData);
        }

        private ResultSet callProcedure() {
            if (GraphCommandObjects.this.graph != null) {
                return GraphCommandObjects.this.graph.graphQuery(this.name, this.query);
            }
            CommandObject commandObject = new CommandObject(new CommandArguments(GraphProtocol.GraphCommand.QUERY).key(this.name).add(this.query).add(GraphProtocol.GraphKeyword.__COMPACT), GraphCommandObjects.this.getBuilder(this.name));
            if (GraphCommandObjects.this.connection != null) {
                return (ResultSet)GraphCommandObjects.this.connection.executeCommand(commandObject);
            }
            try (Connection provided = GraphCommandObjects.this.provider.getConnection(commandObject.getArguments());){
                ResultSet resultSet = (ResultSet)provided.executeCommand(commandObject);
                return resultSet;
            }
        }
    }

    private class GraphCacheImpl
    implements GraphCache {
        private final GraphCacheList labels;
        private final GraphCacheList propertyNames;
        private final GraphCacheList relationshipTypes;

        public GraphCacheImpl(String graphName) {
            this.labels = new GraphCacheList(graphName, "db.labels");
            this.propertyNames = new GraphCacheList(graphName, "db.propertyKeys");
            this.relationshipTypes = new GraphCacheList(graphName, "db.relationshipTypes");
        }

        @Override
        public String getLabel(int index) {
            return this.labels.getCachedData(index);
        }

        @Override
        public String getRelationshipType(int index) {
            return this.relationshipTypes.getCachedData(index);
        }

        @Override
        public String getPropertyName(int index) {
            return this.propertyNames.getCachedData(index);
        }
    }
}

