/*
 * Decompiled with CFR 0.152.
 */
package io.valkey.params;

import io.valkey.CommandArguments;
import io.valkey.Protocol;
import io.valkey.params.IParams;
import java.util.Objects;

public class SetParams
implements IParams {
    private Protocol.Keyword existence;
    private Protocol.Keyword expiration;
    private Long expirationValue;

    public static SetParams setParams() {
        return new SetParams();
    }

    public SetParams nx() {
        this.existence = Protocol.Keyword.NX;
        return this;
    }

    public SetParams xx() {
        this.existence = Protocol.Keyword.XX;
        return this;
    }

    private SetParams expiration(Protocol.Keyword type, Long value) {
        this.expiration = type;
        this.expirationValue = value;
        return this;
    }

    public SetParams ex(long remainingSeconds) {
        return this.expiration(Protocol.Keyword.EX, remainingSeconds);
    }

    public SetParams px(long remainingMilliseconds) {
        return this.expiration(Protocol.Keyword.PX, remainingMilliseconds);
    }

    public SetParams exAt(long timestampSeconds) {
        return this.expiration(Protocol.Keyword.EXAT, timestampSeconds);
    }

    public SetParams pxAt(long timestampMilliseconds) {
        return this.expiration(Protocol.Keyword.PXAT, timestampMilliseconds);
    }

    public SetParams keepttl() {
        return this.keepTtl();
    }

    public SetParams keepTtl() {
        return this.expiration(Protocol.Keyword.KEEPTTL, null);
    }

    @Override
    public void addParams(CommandArguments args) {
        if (this.existence != null) {
            args.add(this.existence);
        }
        if (this.expiration != null) {
            args.add(this.expiration);
            if (this.expirationValue != null) {
                args.add(this.expirationValue);
            }
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SetParams setParams = (SetParams)o;
        return Objects.equals(this.existence, setParams.existence) && Objects.equals(this.expiration, setParams.expiration) && Objects.equals(this.expirationValue, setParams.expirationValue);
    }

    public int hashCode() {
        return Objects.hash(this.existence, this.expiration, this.expirationValue);
    }
}

