/*
 * Decompiled with CFR 0.152.
 */
package io.vantiq.client;

import com.google.gson.Gson;
import com.google.gson.JsonParser;
import com.google.gson.reflect.TypeToken;
import io.vantiq.client.VantiqError;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import okhttp3.Response;

public class VantiqResponse {
    private static final JsonParser parser = new JsonParser();
    private static final Gson gson = new Gson();
    private int count = -1;
    private int statusCode = -1;
    private String contentType;
    private Object body;
    private Throwable exception;
    private List<VantiqError> errors;
    private Response response;

    public static VantiqResponse createFromResponse(Response response, boolean isStreamingResponse) {
        try {
            if (response.isSuccessful()) {
                return new VantiqResponse(VantiqResponse.extractBody(response, isStreamingResponse), response);
            }
            return new VantiqResponse(VantiqResponse.extractErrors(response), response);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return new VantiqResponse(ex);
        }
    }

    public VantiqResponse(Object body, Response response) {
        this.response = response;
        String cntValue = response.header("X-Total-Count");
        if (cntValue != null) {
            try {
                this.count = Integer.parseInt(cntValue);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        this.contentType = response.header("Content-Type");
        this.statusCode = response.code();
        this.body = body;
    }

    public VantiqResponse(List<VantiqError> errors, Response response) {
        this.response = response;
        this.contentType = response.header("Content-Type");
        this.statusCode = response.code();
        this.errors = errors;
    }

    public VantiqResponse(Throwable exception) {
        this.exception = exception;
    }

    protected void setBody(Object body) {
        this.body = body;
    }

    public static Object extractBody(Response response, boolean isStreamingResponse) throws IOException {
        Object body = null;
        if (isStreamingResponse) {
            body = response.body().source();
        } else {
            String contentType = response.header("Content-Type");
            if ("application/json".equals(contentType)) {
                String stringBody = response.body().string();
                if (stringBody != null && stringBody.length() > 0) {
                    body = parser.parse(stringBody);
                }
            } else {
                body = contentType != null && contentType.startsWith("text/") ? response.body().string() : (Object)response.body().bytes();
            }
        }
        return body;
    }

    public static List<VantiqError> extractErrors(Response response) throws IOException {
        VantiqError ve;
        String body = response.body().string();
        if (body != null) {
            body = body.trim();
        }
        if (body.startsWith("[")) {
            ArrayList<VantiqError> listOfErrors;
            Type errorsType = new TypeToken<List<VantiqError>>(){}.getType();
            try {
                listOfErrors = (ArrayList<VantiqError>)gson.fromJson(body, errorsType);
            }
            catch (Exception ex) {
                String code = "io.vantiq.nonjson.error";
                String message = body + " (" + response.code() + ")";
                VantiqError ve2 = new VantiqError(code, message, null);
                listOfErrors = new ArrayList<VantiqError>();
                listOfErrors.add(ve2);
            }
            return listOfErrors;
        }
        try {
            ve = (VantiqError)gson.fromJson(body, VantiqError.class);
        }
        catch (Exception ex) {
            String code = "io.vantiq.nonjson.error";
            String message = body + " (" + response.code() + ")";
            ve = new VantiqError(code, message, null);
        }
        return Collections.singletonList(ve);
    }

    public Response getResponse() {
        return this.response;
    }

    public boolean isSuccess() {
        if (this.response != null) {
            return this.response.isSuccessful();
        }
        return false;
    }

    public boolean hasErrors() {
        return this.errors != null && this.errors.size() > 0;
    }

    public boolean hasException() {
        return this.exception != null;
    }

    public Throwable getException() {
        return this.exception;
    }

    public List<VantiqError> getErrors() {
        return this.errors;
    }

    public int getCount() {
        return this.count;
    }

    public String getContentType() {
        return this.contentType;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public Object getBody() {
        return this.body;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("VantiqResponse[\n");
        sb.append("  statusCode:").append(this.statusCode).append('\n');
        sb.append("  contentType:").append(this.contentType).append('\n');
        if (this.count > -1) {
            sb.append("  count:").append(this.count).append('\n');
        }
        if (this.errors != null) {
            sb.append("  errors:").append(this.errors).append('\n');
        }
        if (this.exception != null) {
            sb.append("  exception:").append(this.exception.getMessage()).append('\n');
        }
        if (this.body != null) {
            sb.append("  body:").append(this.body).append('\n');
        }
        sb.append(']');
        return sb.toString();
    }
}

