/*
 * Decompiled with CFR 0.152.
 */
package io.vantiq.client.internal;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.reflect.TypeToken;
import io.vantiq.client.ResponseHandler;
import io.vantiq.client.SubscriptionCallback;
import io.vantiq.client.VantiqError;
import io.vantiq.client.VantiqResponse;
import io.vantiq.client.internal.VantiqSubscriber;
import io.vantiq.client.internal.VantiqSubscriberLifecycleListener;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Type;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import okhttp3.Authenticator;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.Credentials;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.OkHttpClient;
import okhttp3.Protocol;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okio.ByteString;

public class VantiqSession {
    public static final MediaType APPLICATION_JSON = MediaType.parse((String)"application/json");
    public static final MediaType PLAIN_TEXT = MediaType.parse((String)"plain/text");
    public static final Gson gson = new Gson();
    public static final int DEFAULT_API_VERSION = 1;
    private OkHttpClient client = null;
    private String server;
    private int apiVersion;
    private Authenticator proxyAuthenticator = null;
    private Proxy proxy = null;
    private boolean authenticated;
    private String accessToken;
    private String idToken;
    private String username;
    private long readTimeout = 0L;
    private long writeTimeout = 0L;
    private long connectTimeout = 0L;
    private VantiqSubscriber subscriber;

    public VantiqSession(String server) {
        this(server, 1);
    }

    public VantiqSession(String server, Authenticator proxyAuthenticator) {
        this(server, 1, proxyAuthenticator);
    }

    public VantiqSession(String server, int apiVersion) {
        this(server, apiVersion, null);
    }

    public VantiqSession(String server, int apiVersion, Authenticator proxyAuthenticator) {
        this.server = server;
        this.apiVersion = apiVersion;
        this.proxyAuthenticator = proxyAuthenticator;
        this.createClient();
    }

    private void createClient() {
        ArrayList<Protocol> protocols = new ArrayList<Protocol>();
        protocols.add(Protocol.HTTP_1_1);
        boolean needProxyAuth = this.setupProxyAuthentication();
        OkHttpClient.Builder builder = new OkHttpClient.Builder().readTimeout(this.readTimeout, TimeUnit.MILLISECONDS).writeTimeout(this.writeTimeout, TimeUnit.MILLISECONDS).connectTimeout(this.connectTimeout, TimeUnit.MILLISECONDS).protocols(protocols);
        if (needProxyAuth) {
            builder.proxySelector(ProxySelector.getDefault());
            if (this.proxyAuthenticator != null) {
                builder.proxyAuthenticator(this.proxyAuthenticator);
            }
        }
        this.client = builder.build();
    }

    private boolean setupProxyAuthentication() {
        if (this.proxyAuthenticator != null) {
            return true;
        }
        try {
            URI serverUri = new URI(this.server);
            List<Proxy> proxies = ProxySelector.getDefault().select(serverUri);
            if (proxies.size() == 0 || proxies.size() == 1 && proxies.get(0).type() == Proxy.NO_PROXY.type()) {
                return false;
            }
            String scheme = serverUri.getScheme();
            String proxyUser = System.getProperty(scheme.toLowerCase() + ".proxyUser");
            String proxyPw = System.getProperty(scheme.toLowerCase() + ".proxyPassword");
            this.proxyAuthenticator = proxyUser != null && proxyPw != null ? (route, response) -> {
                String credential = Credentials.basic((String)proxyUser, (String)proxyPw);
                return response.request().newBuilder().header("Proxy-Authorization", credential).build();
            } : Authenticator.JAVA_NET_AUTHENTICATOR;
            return true;
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean isAuthenticated() {
        return this.authenticated;
    }

    public void setAccessToken(String accessToken) {
        this.accessToken = accessToken;
        this.authenticated = this.accessToken != null;
    }

    public String getIdToken() {
        return this.idToken;
    }

    public String getAccessToken() {
        return this.accessToken;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setServer(String server) {
        this.server = server;
    }

    public String getServer() {
        return this.server;
    }

    public int getApiVersion() {
        return this.apiVersion;
    }

    public void setReadTimeout(long timeout) {
        this.readTimeout = timeout;
        this.createClient();
    }

    public long getReadTimeout() {
        return this.readTimeout;
    }

    public void setWriteTimeout(long timeout) {
        this.writeTimeout = timeout;
        this.createClient();
    }

    public long getWriteTimeout() {
        return this.writeTimeout;
    }

    public void setConnectTimeout(long timeout) {
        this.connectTimeout = timeout;
        this.createClient();
    }

    public long getConnectTimeout() {
        return this.connectTimeout;
    }

    public VantiqResponse authenticate(final String username, String password, ResponseHandler responseHandler) {
        JsonElement token;
        JsonElement jsonBody;
        CallbackAdapter cb = null;
        if (responseHandler != null) {
            cb = new CallbackAdapter(responseHandler){

                @Override
                public void responseHook(Object body) {
                    JsonElement token;
                    JsonElement jsonBody = (JsonElement)body;
                    if (jsonBody != null && jsonBody.isJsonObject() && (token = ((JsonObject)jsonBody).get("accessToken")) != null) {
                        VantiqSession.this.username = username;
                        VantiqSession.this.accessToken = token.getAsString();
                        VantiqSession.this.authenticated = true;
                        JsonElement idToken = ((JsonObject)jsonBody).get("idToken");
                        if (idToken != null) {
                            VantiqSession.this.idToken = idToken.getAsString();
                        }
                    }
                }
            };
        }
        String usernameAndPassword = username + ":" + password;
        String encoded = "Basic " + ByteString.encodeUtf8((String)usernameAndPassword).base64();
        VantiqResponse response = this.request(encoded, "GET", "authenticate", null, null, null, false, cb);
        if (response != null && (jsonBody = (JsonElement)response.getBody()) != null && jsonBody.isJsonObject() && (token = ((JsonObject)jsonBody).get("accessToken")) != null) {
            this.username = username;
            this.accessToken = token.getAsString();
            this.authenticated = true;
            JsonElement idToken = ((JsonObject)jsonBody).get("idToken");
            if (idToken != null) {
                this.idToken = idToken.getAsString();
            }
        }
        return response;
    }

    public VantiqResponse revoke(String accessToken, ResponseHandler responseHandler) {
        CallbackAdapter cb = null;
        if (responseHandler != null) {
            cb = new CallbackAdapter(responseHandler){

                @Override
                public void responseHook(Object body) {
                    VantiqSession.this.username = null;
                    VantiqSession.this.accessToken = null;
                    VantiqSession.this.authenticated = false;
                }
            };
        }
        HttpUrl.Builder urlBuilder = HttpUrl.parse((String)this.server).newBuilder();
        urlBuilder.addPathSegments("authenticate/revoke");
        Request.Builder builder = new Request.Builder().url(urlBuilder.build());
        Object reqBody = null;
        builder.addHeader("Content-Type", PLAIN_TEXT.toString());
        builder.method("POST", RequestBody.create((MediaType)PLAIN_TEXT, (String)accessToken));
        Request request = builder.build();
        VantiqResponse response = null;
        if (cb != null) {
            this.client.newCall(request).enqueue((Callback)cb);
            return null;
        }
        try {
            response = VantiqResponse.createFromResponse(this.client.newCall(request).execute(), false);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        if (response != null) {
            this.username = null;
            this.accessToken = null;
            this.authenticated = false;
        }
        return response;
    }

    public VantiqResponse refresh(String accessToken, ResponseHandler responseHandler) {
        JsonElement token;
        JsonElement jsonBody;
        CallbackAdapter cb = null;
        if (responseHandler != null) {
            cb = new CallbackAdapter(responseHandler){

                @Override
                public void responseHook(Object body) {
                    JsonElement token;
                    JsonElement jsonBody = (JsonElement)body;
                    if (jsonBody != null && jsonBody.isJsonObject() && (token = ((JsonObject)jsonBody).get("accessToken")) != null) {
                        VantiqSession.this.accessToken = token.getAsString();
                        VantiqSession.this.authenticated = true;
                        JsonElement idToken = ((JsonObject)jsonBody).get("idToken");
                        if (idToken != null) {
                            VantiqSession.this.idToken = idToken.getAsString();
                        }
                    }
                }
            };
        }
        HttpUrl.Builder urlBuilder = HttpUrl.parse((String)this.server).newBuilder();
        urlBuilder.addPathSegments("authenticate/refresh");
        Request.Builder builder = new Request.Builder().url(urlBuilder.build());
        Object reqBody = null;
        builder.addHeader("Content-Type", PLAIN_TEXT.toString());
        builder.method("POST", RequestBody.create((MediaType)PLAIN_TEXT, (String)accessToken));
        Request request = builder.build();
        VantiqResponse response = null;
        if (cb != null) {
            this.client.newCall(request).enqueue((Callback)cb);
            return null;
        }
        try {
            response = VantiqResponse.createFromResponse(this.client.newCall(request).execute(), false);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        if (response != null && (jsonBody = (JsonElement)response.getBody()) != null && jsonBody.isJsonObject() && (token = ((JsonObject)jsonBody).get("accessToken")) != null) {
            this.accessToken = token.getAsString();
            this.authenticated = true;
            JsonElement idToken = ((JsonObject)jsonBody).get("idToken");
            if (idToken != null) {
                this.idToken = idToken.getAsString();
            }
        }
        return response;
    }

    private String authValue() throws IllegalStateException {
        if (!this.isAuthenticated()) {
            throw new IllegalStateException("Not authenticated");
        }
        return "Bearer " + this.accessToken;
    }

    private String fullpath(String path) {
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        return "api/v" + this.apiVersion + "/" + path;
    }

    public VantiqResponse rawGet(String fullPath, Map<String, String> queryParams, Map<String, String> extraHeaders, ResponseHandler responseHandler) {
        CallbackAdapter cb = responseHandler != null ? new CallbackAdapter(responseHandler) : null;
        return this.request(this.authValue(), "GET", fullPath, queryParams, extraHeaders, null, false, cb);
    }

    public VantiqResponse get(String path, Map<String, String> queryParams, ResponseHandler responseHandler) {
        CallbackAdapter cb = responseHandler != null ? new CallbackAdapter(responseHandler) : null;
        return this.request(this.authValue(), "GET", this.fullpath(path), queryParams, null, null, false, cb);
    }

    public VantiqResponse post(String path, Map<String, String> queryParams, String body, ResponseHandler responseHandler) {
        CallbackAdapter cb = responseHandler != null ? new CallbackAdapter(responseHandler) : null;
        return this.request(this.authValue(), "POST", this.fullpath(path), queryParams, null, body, false, cb);
    }

    public VantiqResponse put(String path, Map<String, String> queryParams, String body, ResponseHandler responseHandler) {
        CallbackAdapter cb = responseHandler != null ? new CallbackAdapter(responseHandler) : null;
        return this.request(this.authValue(), "PUT", this.fullpath(path), queryParams, null, body, false, cb);
    }

    public VantiqResponse delete(String path, Map<String, String> queryParams, ResponseHandler responseHandler) {
        CallbackAdapter cb = responseHandler != null ? new CallbackAdapter(responseHandler) : null;
        return this.request(this.authValue(), "DELETE", this.fullpath(path), queryParams, null, null, false, cb);
    }

    public VantiqResponse upload(String path, File file, String contentType, String documentPath, Map<String, String> queryParams, ResponseHandler responseHandler) {
        CallbackAdapter cb = responseHandler != null ? new CallbackAdapter(responseHandler) : null;
        RequestBody fileBody = RequestBody.create((MediaType)MediaType.parse((String)contentType), (File)file);
        MultipartBody reqBody = new MultipartBody.Builder().setType(MultipartBody.FORM).addFormDataPart("defaultName", documentPath, fileBody).build();
        return this.request(this.authValue(), "POST", this.fullpath(path), queryParams, null, reqBody, false, cb);
    }

    public VantiqResponse download(String path, ResponseHandler responseHandler) {
        CallbackAdapter cb = responseHandler != null ? new CallbackAdapter(responseHandler, true) : null;
        return this.request(this.authValue(), "GET", path, null, null, null, true, cb);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private VantiqResponse request(String authValue, String method, String path, Map<String, String> queryParams, Map<String, String> extraHeaders, Object body, boolean isStreamingResponse, Callback callback) {
        HttpUrl.Builder urlBuilder = HttpUrl.parse((String)this.server).newBuilder();
        urlBuilder.addPathSegments(path);
        if (queryParams != null) {
            for (Map.Entry<String, String> entry : queryParams.entrySet()) {
                urlBuilder.setQueryParameter(entry.getKey(), entry.getValue());
            }
        }
        Request.Builder builder = new Request.Builder().url(urlBuilder.build()).addHeader("Authorization", authValue);
        if (extraHeaders != null) {
            for (Map.Entry<String, String> entry : extraHeaders.entrySet()) {
                String key = entry.getKey();
                String value = entry.getValue();
                builder.addHeader(key, value);
            }
        }
        Object var11_13 = null;
        if (body != null) {
            if (body instanceof String) {
                builder.addHeader("Content-Type", APPLICATION_JSON.toString());
                builder.method(method, RequestBody.create((MediaType)APPLICATION_JSON, (String)((String)body)));
            } else {
                if (!(body instanceof RequestBody)) throw new IllegalArgumentException("Illegal request body type.  Must be 'String' or 'RequestBody'");
                builder.method(method, (RequestBody)body);
            }
        } else {
            builder.method(method, null);
        }
        Request request = builder.build();
        if (callback != null) {
            this.client.newCall(request).enqueue(callback);
            return null;
        }
        try {
            return VantiqResponse.createFromResponse(this.client.newCall(request).execute(), isStreamingResponse);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public void subscribe(final String path, final SubscriptionCallback callback, boolean enablePings, final Map<String, Object> parameters) {
        if (!this.isAuthenticated()) {
            throw new IllegalStateException("Not authenticated");
        }
        if (this.subscriber == null) {
            this.subscriber = new VantiqSubscriber(this, this.client, enablePings);
            this.subscriber.connect(new VantiqSubscriberLifecycleListener(){

                @Override
                public void onConnect() {
                    VantiqSession.this.subscriber.subscribe(path, callback, parameters);
                }

                @Override
                public void onError(String message, ResponseBody body) {
                    callback.onError(message);
                }

                @Override
                public void onFailure(Throwable t) {
                    callback.onFailure(t);
                }

                @Override
                public void onClose() {
                }
            });
        } else {
            this.subscriber.subscribe(path, callback, parameters);
        }
    }

    public void ack(String requestId, String subscriptionId, Double sequenceId, Double partitionId) throws IOException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("subscriptionId", subscriptionId);
        params.put("sequenceId", sequenceId);
        params.put("partitionId", partitionId);
        this.subscriber.ack(requestId, subscriptionId, sequenceId, partitionId);
    }

    public void unsubscribeAll() {
        if (this.subscriber != null) {
            this.subscriber.close();
            this.subscriber = null;
        }
    }

    public void close() {
        this.subscriber.close();
        this.subscriber = null;
    }

    static class CallbackAdapter
    implements Callback {
        private ResponseHandler responseHandler;
        private boolean isStreamingResponse = false;

        protected void responseHook(Object body) {
        }

        public CallbackAdapter(ResponseHandler responseHandler) {
            this(responseHandler, false);
        }

        public CallbackAdapter(ResponseHandler responseHandler, boolean isStreamingResponse) {
            this.responseHandler = responseHandler;
            this.isStreamingResponse = isStreamingResponse;
        }

        public void onResponse(Call call, Response response) throws IOException {
            if (response.isSuccessful()) {
                Object body = VantiqResponse.extractBody(response, this.isStreamingResponse);
                this.responseHook(body);
                this.responseHandler.onSuccess(body, response);
            } else {
                try {
                    String bodyString = response.body().string();
                    ArrayList<VantiqError> errors = null;
                    Type errorsType = new TypeToken<List<VantiqError>>(){}.getType();
                    try {
                        errors = (ArrayList<VantiqError>)gson.fromJson(bodyString, errorsType);
                    }
                    catch (Exception ex) {
                        errors = null;
                    }
                    if (errors == null && bodyString.length() > 0) {
                        JsonObject jo = null;
                        try {
                            jo = (JsonObject)gson.fromJson(bodyString, JsonObject.class);
                        }
                        catch (Exception ex) {
                            String code = "io.vantiq.nonjson.error";
                            String message = bodyString + " (" + response.code() + ")";
                            VantiqError ve = new VantiqError(code, message, null);
                            errors = new ArrayList();
                            errors.add(ve);
                        }
                        if (jo != null) {
                            errors = new ArrayList<VantiqError>();
                            String code = "io.vantiq.status";
                            String message = jo.get("error").getAsString() + " (" + response.code() + ")";
                            VantiqError ve = new VantiqError(code, message, null);
                            errors.add(ve);
                        }
                    }
                    this.responseHandler.onError((List<VantiqError>)errors, response);
                }
                catch (IOException ex) {
                    this.responseHandler.onFailure(ex);
                }
            }
        }

        public void onFailure(Call call, IOException t) {
            this.responseHandler.onFailure(t);
        }
    }
}

