/*
 * Decompiled with CFR 0.152.
 */
package io.vavr.beanvalidation2.constraintvalidators;

import io.vavr.collection.Traversable;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import javax.validation.constraints.Size;

public class SizeValidatorForTraversable
implements ConstraintValidator<Size, Traversable<?>> {
    private int min;
    private int max;

    public void initialize(Size constraintAnnotation) {
        this.min = constraintAnnotation.min();
        this.max = constraintAnnotation.max();
        if (this.min < 0) {
            throw new IllegalArgumentException("The min parameter cannot be negative.");
        }
        if (this.max < this.min) {
            throw new IllegalArgumentException("The max parameter cannot be less than the min parameter");
        }
    }

    public boolean isValid(Traversable<?> value, ConstraintValidatorContext context) {
        return value == null || value.size() >= this.min && value.size() <= this.max;
    }
}

