/*
 * Decompiled with CFR 0.152.
 */
package io.vavr.jackson.datatype.deserialize;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.deser.ResolvableDeserializer;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import java.util.ArrayList;
import java.util.List;

abstract class ValueDeserializer<T>
extends StdDeserializer<T>
implements ResolvableDeserializer {
    private static final long serialVersionUID = 1L;
    private final JavaType javaType;
    private final int typeCount;
    private final List<JsonDeserializer<?>> deserializers;

    ValueDeserializer(JavaType valueType, int typeCount) {
        super(valueType);
        this.javaType = valueType;
        this.typeCount = typeCount;
        this.deserializers = new ArrayList(typeCount);
    }

    int deserializersCount() {
        return this.deserializers.size();
    }

    JsonDeserializer<?> deserializer(int index) {
        return this.deserializers.get(index);
    }

    public void resolve(DeserializationContext ctxt) throws JsonMappingException {
        if (this.javaType.isCollectionLikeType() || this.javaType.isReferenceType()) {
            this.deserializers.add(ctxt.findRootValueDeserializer(this.javaType.getContentType()));
            return;
        }
        for (int i = 0; i < this.typeCount; ++i) {
            JavaType containedType = this.javaType.containedTypeOrUnknown(i);
            this.deserializers.add(ctxt.findRootValueDeserializer(containedType));
        }
    }

    static JsonMappingException mappingException(DeserializationContext ctxt, Class<?> targetClass, JsonToken token) {
        String tokenDesc = token == null ? "<end of input>" : String.format("%s token", token);
        return JsonMappingException.from((JsonParser)ctxt.getParser(), (String)String.format("Can not deserialize instance of %s out of %s", ValueDeserializer._calcName(targetClass), tokenDesc));
    }

    private static String _calcName(Class<?> cls) {
        if (cls.isArray()) {
            return ValueDeserializer._calcName(cls.getComponentType()) + "[]";
        }
        return cls.getName();
    }
}

