/*
 * Decompiled with CFR 0.152.
 */
package io.vavr.jackson.datatype.deserialize;

import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.KeyDeserializer;
import com.fasterxml.jackson.databind.deser.ResolvableDeserializer;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.type.MapLikeType;
import java.io.Serializable;
import java.util.Comparator;

abstract class MaplikeDeserializer<T>
extends StdDeserializer<T>
implements ResolvableDeserializer {
    private static final long serialVersionUID = 1L;
    final MapLikeType javaType;
    Comparator<Object> keyComparator;
    KeyDeserializer keyDeserializer;
    JsonDeserializer<?> valueDeserializer;

    MaplikeDeserializer(JavaType valueType) {
        super(valueType);
        this.javaType = (MapLikeType)valueType;
    }

    public void resolve(DeserializationContext ctxt) throws JsonMappingException {
        JavaType keyType = this.javaType.getKeyType();
        this.keyComparator = keyType.getRawClass().isAssignableFrom(Comparable.class) ? (Comparator & Serializable)(o1, o2) -> ((Comparable)o1).compareTo(o2) : (Comparator & Serializable)(o1, o2) -> o1.toString().compareTo(o2.toString());
        this.keyDeserializer = ctxt.findKeyDeserializer(keyType, null);
        this.valueDeserializer = ctxt.findRootValueDeserializer(this.javaType.getContentType());
    }
}

