/*
 * Decompiled with CFR 0.152.
 */
package io.vavr.jackson.datatype.deserialize;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.deser.ContextualDeserializer;
import com.fasterxml.jackson.databind.jsontype.TypeDeserializer;
import io.vavr.control.Option;
import io.vavr.jackson.datatype.deserialize.ValueDeserializer;
import java.io.IOException;

class OptionDeserializer
extends ValueDeserializer<Option<?>>
implements ContextualDeserializer {
    private static final long serialVersionUID = 1L;
    private final JavaType fullType;
    private final JavaType valueType;
    private final boolean plainMode;
    private final TypeDeserializer valueTypeDeserializer;
    private final JsonDeserializer<?> valueDeserializer;
    private JsonDeserializer<?> stringDeserializer;

    OptionDeserializer(JavaType fullType, JavaType valueType, TypeDeserializer typeDeser, JsonDeserializer<?> valueDeser, boolean plainMode) {
        super(fullType, 1);
        this.fullType = fullType;
        this.valueType = valueType;
        this.valueTypeDeserializer = typeDeser;
        this.valueDeserializer = valueDeser;
        this.plainMode = plainMode;
    }

    private OptionDeserializer(OptionDeserializer origin, TypeDeserializer typeDeser, JsonDeserializer<?> valueDeser) {
        this(origin.fullType, origin.valueType, typeDeser, valueDeser, origin.plainMode);
        this.stringDeserializer = origin.stringDeserializer;
    }

    public Option<?> deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        if (this.plainMode) {
            if (this.valueTypeDeserializer == null) {
                Object obj = this.valueDeserializer.deserialize(p, ctxt);
                return Option.of((Object)obj);
            }
            Object obj = this.valueDeserializer.deserializeWithType(p, ctxt, this.valueTypeDeserializer);
            return Option.of((Object)obj);
        }
        boolean defined = false;
        Object value = null;
        int cnt = 0;
        while (p.nextToken() != JsonToken.END_ARRAY) {
            switch (++cnt) {
                case 1: {
                    JsonToken currentToken = p.getCurrentToken();
                    String def = (String)this.stringDeserializer.deserialize(p, ctxt);
                    if ("defined".equals(def)) {
                        defined = true;
                        break;
                    }
                    if ("undefined".equals(def)) {
                        defined = false;
                        break;
                    }
                    throw OptionDeserializer.mappingException(ctxt, this.fullType.getRawClass(), currentToken);
                }
                case 2: {
                    value = this.valueTypeDeserializer == null ? this.valueDeserializer.deserialize(p, ctxt) : this.valueDeserializer.deserializeWithType(p, ctxt, this.valueTypeDeserializer);
                }
            }
        }
        if (defined) {
            if (cnt != 2) {
                throw OptionDeserializer.mappingException(ctxt, this.fullType.getRawClass(), null);
            }
            return Option.some(value);
        }
        if (cnt != 1) {
            throw OptionDeserializer.mappingException(ctxt, this.fullType.getRawClass(), null);
        }
        return Option.none();
    }

    @Override
    public void resolve(DeserializationContext ctxt) throws JsonMappingException {
        super.resolve(ctxt);
        this.stringDeserializer = ctxt.findContextualValueDeserializer(ctxt.constructType(String.class), null);
    }

    public Option<?> getNullValue(DeserializationContext ctxt) throws JsonMappingException {
        return Option.none();
    }

    public JsonDeserializer<?> createContextual(DeserializationContext ctxt, BeanProperty property) throws JsonMappingException {
        JsonDeserializer deser = this.valueDeserializer;
        TypeDeserializer typeDeser = this.valueTypeDeserializer;
        JavaType refType = this.valueType;
        deser = deser == null ? ctxt.findContextualValueDeserializer(refType, property) : ctxt.handleSecondaryContextualization(deser, property, refType);
        if (typeDeser != null) {
            typeDeser = typeDeser.forProperty(property);
        }
        return this.withResolved(refType, typeDeser, deser);
    }

    private OptionDeserializer withResolved(JavaType refType, TypeDeserializer typeDeser, JsonDeserializer<?> valueDeser) {
        if (refType == this.valueType && valueDeser == this.valueDeserializer && typeDeser == this.valueTypeDeserializer) {
            return this;
        }
        return new OptionDeserializer(this, typeDeser, valueDeser);
    }
}

