/*
 * Decompiled with CFR 0.152.
 */
package io.vavr.jackson.datatype.deserialize;

import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.KeyDeserializer;
import com.fasterxml.jackson.databind.deser.Deserializers;
import com.fasterxml.jackson.databind.jsontype.TypeDeserializer;
import com.fasterxml.jackson.databind.type.CollectionLikeType;
import com.fasterxml.jackson.databind.type.MapLikeType;
import com.fasterxml.jackson.databind.type.ReferenceType;
import io.vavr.CheckedFunction0;
import io.vavr.CheckedFunction1;
import io.vavr.CheckedFunction2;
import io.vavr.CheckedFunction3;
import io.vavr.CheckedFunction4;
import io.vavr.CheckedFunction5;
import io.vavr.CheckedFunction6;
import io.vavr.CheckedFunction7;
import io.vavr.CheckedFunction8;
import io.vavr.Function0;
import io.vavr.Function1;
import io.vavr.Function2;
import io.vavr.Function3;
import io.vavr.Function4;
import io.vavr.Function5;
import io.vavr.Function6;
import io.vavr.Function7;
import io.vavr.Function8;
import io.vavr.Lazy;
import io.vavr.Tuple0;
import io.vavr.Tuple1;
import io.vavr.Tuple2;
import io.vavr.Tuple3;
import io.vavr.Tuple4;
import io.vavr.Tuple5;
import io.vavr.Tuple6;
import io.vavr.Tuple7;
import io.vavr.Tuple8;
import io.vavr.collection.CharSeq;
import io.vavr.collection.Map;
import io.vavr.collection.Multimap;
import io.vavr.collection.PriorityQueue;
import io.vavr.collection.Seq;
import io.vavr.collection.Set;
import io.vavr.control.Either;
import io.vavr.control.Option;
import io.vavr.jackson.datatype.VavrModule;
import io.vavr.jackson.datatype.deserialize.CharSeqDeserializer;
import io.vavr.jackson.datatype.deserialize.EitherDeserializer;
import io.vavr.jackson.datatype.deserialize.LazyDeserializer;
import io.vavr.jackson.datatype.deserialize.MapDeserializer;
import io.vavr.jackson.datatype.deserialize.MultimapDeserializer;
import io.vavr.jackson.datatype.deserialize.OptionDeserializer;
import io.vavr.jackson.datatype.deserialize.PriorityQueueDeserializer;
import io.vavr.jackson.datatype.deserialize.SeqDeserializer;
import io.vavr.jackson.datatype.deserialize.SerializableDeserializer;
import io.vavr.jackson.datatype.deserialize.SetDeserializer;
import io.vavr.jackson.datatype.deserialize.Tuple0Deserializer;
import io.vavr.jackson.datatype.deserialize.Tuple1Deserializer;
import io.vavr.jackson.datatype.deserialize.Tuple2Deserializer;
import io.vavr.jackson.datatype.deserialize.Tuple3Deserializer;
import io.vavr.jackson.datatype.deserialize.Tuple4Deserializer;
import io.vavr.jackson.datatype.deserialize.Tuple5Deserializer;
import io.vavr.jackson.datatype.deserialize.Tuple6Deserializer;
import io.vavr.jackson.datatype.deserialize.Tuple7Deserializer;
import io.vavr.jackson.datatype.deserialize.Tuple8Deserializer;

public class VavrDeserializers
extends Deserializers.Base {
    private final VavrModule.Settings settings;

    public VavrDeserializers(VavrModule.Settings settings) {
        this.settings = settings;
    }

    public JsonDeserializer<?> findBeanDeserializer(JavaType type, DeserializationConfig config, BeanDescription beanDesc) throws JsonMappingException {
        Class raw = type.getRawClass();
        if (Either.class.isAssignableFrom(raw)) {
            return new EitherDeserializer(type);
        }
        if (Tuple0.class.isAssignableFrom(raw)) {
            return new Tuple0Deserializer(type);
        }
        if (Tuple1.class.isAssignableFrom(raw)) {
            return new Tuple1Deserializer(type);
        }
        if (Tuple2.class.isAssignableFrom(raw)) {
            return new Tuple2Deserializer(type);
        }
        if (Tuple3.class.isAssignableFrom(raw)) {
            return new Tuple3Deserializer(type);
        }
        if (Tuple4.class.isAssignableFrom(raw)) {
            return new Tuple4Deserializer(type);
        }
        if (Tuple5.class.isAssignableFrom(raw)) {
            return new Tuple5Deserializer(type);
        }
        if (Tuple6.class.isAssignableFrom(raw)) {
            return new Tuple6Deserializer(type);
        }
        if (Tuple7.class.isAssignableFrom(raw)) {
            return new Tuple7Deserializer(type);
        }
        if (Tuple8.class.isAssignableFrom(raw)) {
            return new Tuple8Deserializer(type);
        }
        if (Function0.class.isAssignableFrom(raw)) {
            return new SerializableDeserializer(type);
        }
        if (Function1.class.isAssignableFrom(raw)) {
            return new SerializableDeserializer(type);
        }
        if (Function2.class.isAssignableFrom(raw)) {
            return new SerializableDeserializer(type);
        }
        if (Function3.class.isAssignableFrom(raw)) {
            return new SerializableDeserializer(type);
        }
        if (Function4.class.isAssignableFrom(raw)) {
            return new SerializableDeserializer(type);
        }
        if (Function5.class.isAssignableFrom(raw)) {
            return new SerializableDeserializer(type);
        }
        if (Function6.class.isAssignableFrom(raw)) {
            return new SerializableDeserializer(type);
        }
        if (Function7.class.isAssignableFrom(raw)) {
            return new SerializableDeserializer(type);
        }
        if (Function8.class.isAssignableFrom(raw)) {
            return new SerializableDeserializer(type);
        }
        if (CheckedFunction0.class.isAssignableFrom(raw)) {
            return new SerializableDeserializer(type);
        }
        if (CheckedFunction1.class.isAssignableFrom(raw)) {
            return new SerializableDeserializer(type);
        }
        if (CheckedFunction2.class.isAssignableFrom(raw)) {
            return new SerializableDeserializer(type);
        }
        if (CheckedFunction3.class.isAssignableFrom(raw)) {
            return new SerializableDeserializer(type);
        }
        if (CheckedFunction4.class.isAssignableFrom(raw)) {
            return new SerializableDeserializer(type);
        }
        if (CheckedFunction5.class.isAssignableFrom(raw)) {
            return new SerializableDeserializer(type);
        }
        if (CheckedFunction6.class.isAssignableFrom(raw)) {
            return new SerializableDeserializer(type);
        }
        if (CheckedFunction7.class.isAssignableFrom(raw)) {
            return new SerializableDeserializer(type);
        }
        if (CheckedFunction8.class.isAssignableFrom(raw)) {
            return new SerializableDeserializer(type);
        }
        return super.findBeanDeserializer(type, config, beanDesc);
    }

    public JsonDeserializer<?> findReferenceDeserializer(ReferenceType type, DeserializationConfig config, BeanDescription beanDesc, TypeDeserializer contentTypeDeserializer, JsonDeserializer<?> contentDeserializer) throws JsonMappingException {
        Class raw = type.getRawClass();
        if (raw == Lazy.class) {
            return new LazyDeserializer((JavaType)type, type.getContentType(), contentTypeDeserializer, contentDeserializer);
        }
        if (raw == Option.class) {
            return new OptionDeserializer((JavaType)type, type.getContentType(), contentTypeDeserializer, contentDeserializer, this.settings.useOptionInPlainFormat());
        }
        return super.findReferenceDeserializer(type, config, beanDesc, contentTypeDeserializer, contentDeserializer);
    }

    public JsonDeserializer<?> findCollectionLikeDeserializer(CollectionLikeType collectionType, DeserializationConfig config, BeanDescription beanDesc, TypeDeserializer elementTypeDeserializer, JsonDeserializer<?> elementDeserializer) throws JsonMappingException {
        Class raw = collectionType.getRawClass();
        if (raw == CharSeq.class) {
            return new CharSeqDeserializer((JavaType)collectionType);
        }
        if (Seq.class.isAssignableFrom(raw)) {
            return new SeqDeserializer((JavaType)collectionType, collectionType.getContentType(), elementTypeDeserializer, elementDeserializer, this.settings.deserializeNullAsEmptyCollection());
        }
        if (Set.class.isAssignableFrom(raw)) {
            return new SetDeserializer((JavaType)collectionType, collectionType.getContentType(), elementTypeDeserializer, elementDeserializer, this.settings.deserializeNullAsEmptyCollection());
        }
        if (PriorityQueue.class.isAssignableFrom(raw)) {
            return new PriorityQueueDeserializer((JavaType)collectionType, collectionType.getContentType(), elementTypeDeserializer, elementDeserializer, this.settings.deserializeNullAsEmptyCollection());
        }
        return super.findCollectionLikeDeserializer(collectionType, config, beanDesc, elementTypeDeserializer, elementDeserializer);
    }

    public JsonDeserializer<?> findMapLikeDeserializer(MapLikeType type, DeserializationConfig config, BeanDescription beanDesc, KeyDeserializer keyDeserializer, TypeDeserializer elementTypeDeserializer, JsonDeserializer<?> elementDeserializer) throws JsonMappingException {
        Class raw = type.getRawClass();
        if (Map.class.isAssignableFrom(raw)) {
            return new MapDeserializer(type, keyDeserializer, elementTypeDeserializer, elementDeserializer);
        }
        if (Multimap.class.isAssignableFrom(raw)) {
            return new MultimapDeserializer(type, keyDeserializer, elementTypeDeserializer, elementDeserializer);
        }
        return super.findMapLikeDeserializer(type, config, beanDesc, keyDeserializer, elementTypeDeserializer, elementDeserializer);
    }
}

