/*
 * Decompiled with CFR 0.152.
 */
package io.vavr.jackson.datatype.serialize;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.introspect.Annotated;
import com.fasterxml.jackson.databind.introspect.AnnotatedMember;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.fasterxml.jackson.databind.ser.ContextualSerializer;
import io.vavr.Lazy;
import io.vavr.jackson.datatype.serialize.HListSerializer;
import java.io.IOException;

class LazySerializer
extends HListSerializer<Lazy<?>>
implements ContextualSerializer {
    private static final long serialVersionUID = 1L;
    private final JavaType fullType;
    private final JavaType valueType;
    private final TypeSerializer valueTypeSerializer;
    private final JsonSerializer<Object> valueSerializer;

    LazySerializer(JavaType fullType, JavaType valueType, TypeSerializer typeSer, JsonSerializer<?> valueSer) {
        super(fullType);
        this.fullType = fullType;
        this.valueType = valueType;
        this.valueTypeSerializer = typeSer;
        this.valueSerializer = valueSer;
    }

    public void serialize(Lazy<?> value, JsonGenerator gen, SerializerProvider provider) throws IOException {
        if (this.valueSerializer != null) {
            this.valueSerializer.serialize(value.get(), gen, provider);
        } else {
            this.write(value.get(), 0, gen, provider);
        }
    }

    public JsonSerializer<?> createContextual(SerializerProvider provider, BeanProperty property) throws JsonMappingException {
        JsonSerializer ser;
        TypeSerializer vts = this.valueTypeSerializer;
        if (vts != null) {
            vts = vts.forProperty(property);
        }
        if ((ser = this.valueSerializer) == null) {
            if (this.useStatic(provider, property, this.valueType)) {
                ser = provider.findTypedValueSerializer(this.valueType, true, property);
            }
        } else {
            ser = provider.handlePrimaryContextualization(ser, property);
        }
        return new LazySerializer(this.fullType, this.valueType, vts, ser);
    }

    private boolean useStatic(SerializerProvider provider, BeanProperty property, JavaType referredType) {
        AnnotatedMember ann;
        if (referredType.isJavaLangObject()) {
            return false;
        }
        if (referredType.isFinal()) {
            return true;
        }
        if (referredType.useStaticType()) {
            return true;
        }
        AnnotationIntrospector intr = provider.getAnnotationIntrospector();
        if (intr != null && property != null && (ann = property.getMember()) != null) {
            JsonSerialize.Typing t = intr.findSerializationTyping((Annotated)property.getMember());
            if (t == JsonSerialize.Typing.STATIC) {
                return true;
            }
            if (t == JsonSerialize.Typing.DYNAMIC) {
                return false;
            }
        }
        return provider.isEnabled(MapperFeature.USE_STATIC_TYPING);
    }
}

