/*
 * Decompiled with CFR 0.152.
 */
package io.vavr.jackson.datatype.serialize;

import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.ContextualSerializer;
import com.fasterxml.jackson.databind.type.MapLikeType;
import com.fasterxml.jackson.databind.type.TypeFactory;
import io.vavr.collection.Map;
import io.vavr.jackson.datatype.serialize.ValueSerializer;
import java.io.IOException;
import java.util.LinkedHashMap;

class MapSerializer
extends ValueSerializer<Map<?, ?>>
implements ContextualSerializer {
    private static final long serialVersionUID = 1L;
    private final MapLikeType mapType;

    MapSerializer(MapLikeType mapType, BeanProperty beanProperty) {
        super((JavaType)mapType, beanProperty);
        this.mapType = mapType;
    }

    MapSerializer(MapLikeType mapType) {
        this(mapType, null);
    }

    @Override
    Object toJavaObj(Map<?, ?> value) throws IOException {
        return value.toJavaMap();
    }

    @Override
    JavaType emulatedJavaType(TypeFactory typeFactory) {
        return typeFactory.constructMapType(LinkedHashMap.class, this.mapType.getKeyType(), this.mapType.getContentType());
    }

    public boolean isEmpty(SerializerProvider provider, Map<?, ?> value) {
        return value.isEmpty();
    }

    public JsonSerializer<?> createContextual(SerializerProvider prov, BeanProperty property) throws JsonMappingException {
        if (property == this.beanProperty) {
            return this;
        }
        return new MapSerializer(this.mapType, property);
    }
}

