/*
 * Decompiled with CFR 0.152.
 */
package io.vavr.jackson.datatype.deserialize;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import io.vavr.control.Option;
import io.vavr.jackson.datatype.deserialize.ValueDeserializer;
import java.io.IOException;

class OptionDeserializer
extends ValueDeserializer<Option<?>> {
    private static final long serialVersionUID = 1L;
    private final JavaType javaType;
    private final boolean plainMode;
    private JsonDeserializer<?> stringDeserializer;

    OptionDeserializer(JavaType valueType, boolean plainMode) {
        super(valueType, 1);
        this.javaType = valueType;
        this.plainMode = plainMode;
    }

    public Option<?> deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        if (this.plainMode) {
            Object obj = this.deserializer(0).deserialize(p, ctxt);
            return Option.of((Object)obj);
        }
        boolean defined = false;
        Object value = null;
        int cnt = 0;
        while (p.nextToken() != JsonToken.END_ARRAY) {
            switch (++cnt) {
                case 1: {
                    JsonToken currentToken = p.getCurrentToken();
                    String def = (String)this.stringDeserializer.deserialize(p, ctxt);
                    if ("defined".equals(def)) {
                        defined = true;
                        break;
                    }
                    if ("undefined".equals(def)) {
                        defined = false;
                        break;
                    }
                    throw OptionDeserializer.mappingException(ctxt, this.javaType.getRawClass(), currentToken);
                }
                case 2: {
                    value = this.deserializer(0).deserialize(p, ctxt);
                }
            }
        }
        if (defined) {
            if (cnt != 2) {
                throw OptionDeserializer.mappingException(ctxt, this.javaType.getRawClass(), null);
            }
            return Option.some(value);
        }
        if (cnt != 1) {
            throw OptionDeserializer.mappingException(ctxt, this.javaType.getRawClass(), null);
        }
        return Option.none();
    }

    @Override
    public void resolve(DeserializationContext ctxt) throws JsonMappingException {
        super.resolve(ctxt);
        this.stringDeserializer = ctxt.findContextualValueDeserializer(ctxt.constructType(String.class), null);
    }

    public Option<?> getNullValue(DeserializationContext ctxt) throws JsonMappingException {
        return Option.none();
    }
}

