/*
 * Decompiled with CFR 0.152.
 */
package io.vavr.jackson.datatype.deserialize;

import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonMappingException;
import io.vavr.collection.Array;
import io.vavr.collection.List;
import io.vavr.collection.Queue;
import io.vavr.collection.Seq;
import io.vavr.collection.Stream;
import io.vavr.collection.Vector;
import io.vavr.jackson.datatype.deserialize.ArrayDeserializer;

class SeqDeserializer
extends ArrayDeserializer<Seq<?>> {
    private static final long serialVersionUID = 1L;
    private final JavaType javaType;

    SeqDeserializer(JavaType valueType, boolean deserializeNullAsEmptyCollection) {
        super(valueType, 1, deserializeNullAsEmptyCollection);
        this.javaType = valueType;
    }

    @Override
    Seq<?> create(java.util.List<Object> result, DeserializationContext ctxt) throws JsonMappingException {
        if (Array.class.isAssignableFrom(this.javaType.getRawClass())) {
            return Array.ofAll(result);
        }
        if (Queue.class.isAssignableFrom(this.javaType.getRawClass())) {
            return Queue.ofAll(result);
        }
        if (Stream.class.isAssignableFrom(this.javaType.getRawClass())) {
            return Stream.ofAll(result);
        }
        if (Vector.class.isAssignableFrom(this.javaType.getRawClass())) {
            return Vector.ofAll(result);
        }
        return List.ofAll(result);
    }
}

