/*
 * Decompiled with CFR 0.152.
 */
package io.vavr.jackson.datatype.serialize;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import io.vavr.control.Either;
import java.io.IOException;

class EitherSerializer
extends StdSerializer<Either<?, ?>> {
    private static final long serialVersionUID = 1L;
    private final JavaType type;

    EitherSerializer(JavaType type) {
        super(type);
        this.type = type;
    }

    public void serialize(Either<?, ?> value, JsonGenerator gen, SerializerProvider provider) throws IOException {
        gen.writeStartArray();
        if (value.isLeft()) {
            gen.writeString("left");
            this.write(value.left().get(), 0, gen, provider);
        } else {
            gen.writeString("right");
            this.write(value.right().get(), 1, gen, provider);
        }
        gen.writeEndArray();
    }

    private void write(Object val, int containedTypeIndex, JsonGenerator gen, SerializerProvider provider) throws IOException {
        if (val != null) {
            if (this.type.containedTypeCount() > containedTypeIndex) {
                JavaType containedType = this.type.containedType(containedTypeIndex);
                JsonSerializer ser = containedType.getRawClass() != Object.class ? provider.findTypedValueSerializer(this.type.containedType(containedTypeIndex), true, null) : provider.findTypedValueSerializer(val.getClass(), true, null);
                ser.serialize(val, gen, provider);
            } else {
                gen.writeObject(val);
            }
        } else {
            gen.writeNull();
        }
    }

    public boolean isEmpty(SerializerProvider provider, Either<?, ?> value) {
        return value.isEmpty();
    }
}

