/*
 * Decompiled with CFR 0.152.
 */
package io.vavr.jackson.datatype.serialize;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.type.CollectionType;
import com.fasterxml.jackson.databind.type.TypeFactory;
import io.vavr.collection.Multimap;
import io.vavr.jackson.datatype.serialize.ValueSerializer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;

class MultimapSerializer
extends ValueSerializer<Multimap<?, ?>> {
    private static final long serialVersionUID = 1L;

    MultimapSerializer(JavaType type) {
        super(type);
    }

    @Override
    Object toJavaObj(Multimap<?, ?> value) throws IOException {
        LinkedHashMap result = new LinkedHashMap();
        value.forEach(e -> {
            ArrayList<Object> list = (ArrayList<Object>)result.get(e._1);
            if (list == null) {
                list = new ArrayList<Object>();
                result.put(e._1, list);
            }
            list.add(e._2);
        });
        return result;
    }

    @Override
    JavaType emulatedJavaType(JavaType type, TypeFactory typeFactory) {
        CollectionType containerType = typeFactory.constructCollectionType(ArrayList.class, type.containedType(1));
        return typeFactory.constructMapType(LinkedHashMap.class, type.containedType(0), (JavaType)containerType);
    }

    public boolean isEmpty(SerializerProvider provider, Multimap<?, ?> value) {
        return value.isEmpty();
    }
}

