/*
 * Decompiled with CFR 0.152.
 */
package io.vavr.jackson.datatype.deserialize;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JavaType;
import io.vavr.Tuple;
import io.vavr.Tuple2;
import io.vavr.collection.HashMap;
import io.vavr.collection.LinkedHashMap;
import io.vavr.collection.Map;
import io.vavr.collection.SortedMap;
import io.vavr.collection.TreeMap;
import io.vavr.jackson.datatype.deserialize.MaplikeDeserializer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;

class MapDeserializer
extends MaplikeDeserializer<Map<?, ?>> {
    private static final long serialVersionUID = 1L;

    MapDeserializer(JavaType valueType) {
        super(valueType);
    }

    public Map<?, ?> deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        ArrayList<Tuple2> result = new ArrayList<Tuple2>();
        while (p.nextToken() != JsonToken.END_OBJECT) {
            String name = p.getCurrentName();
            Object key = this.keyDeserializer.deserializeKey(name, ctxt);
            p.nextToken();
            result.add(Tuple.of((Object)key, (Object)this.valueDeserializer.deserialize(p, ctxt)));
        }
        if (SortedMap.class.isAssignableFrom(this.handledType())) {
            return TreeMap.ofEntries((Comparator)this.keyComparator, result);
        }
        if (LinkedHashMap.class.isAssignableFrom(this.handledType())) {
            return LinkedHashMap.ofEntries(result);
        }
        return HashMap.ofEntries(result);
    }
}

