/*
 * Decompiled with CFR 0.152.
 */
package io.vavr.jackson.datatype;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.type.CollectionLikeType;
import com.fasterxml.jackson.databind.type.MapLikeType;
import com.fasterxml.jackson.databind.type.ReferenceType;
import com.fasterxml.jackson.databind.type.TypeBindings;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.fasterxml.jackson.databind.type.TypeModifier;
import io.vavr.Lazy;
import io.vavr.collection.CharSeq;
import io.vavr.collection.Map;
import io.vavr.collection.Multimap;
import io.vavr.collection.PriorityQueue;
import io.vavr.collection.Seq;
import io.vavr.collection.Set;
import io.vavr.control.Option;
import java.lang.reflect.Type;

public class VavrTypeModifier
extends TypeModifier {
    public JavaType modifyType(JavaType type, Type jdkType, TypeBindings bindings, TypeFactory typeFactory) {
        Class raw = type.getRawClass();
        if (Seq.class.isAssignableFrom(raw) && CharSeq.class != raw) {
            return CollectionLikeType.upgradeFrom((JavaType)type, (JavaType)type.containedTypeOrUnknown(0));
        }
        if (Set.class.isAssignableFrom(raw)) {
            return CollectionLikeType.upgradeFrom((JavaType)type, (JavaType)type.containedTypeOrUnknown(0));
        }
        if (PriorityQueue.class.isAssignableFrom(raw)) {
            return CollectionLikeType.upgradeFrom((JavaType)type, (JavaType)type.containedTypeOrUnknown(0));
        }
        if (Map.class.isAssignableFrom(raw)) {
            return MapLikeType.upgradeFrom((JavaType)type, (JavaType)type.containedTypeOrUnknown(0), (JavaType)type.containedTypeOrUnknown(1));
        }
        if (Multimap.class.isAssignableFrom(raw)) {
            return MapLikeType.upgradeFrom((JavaType)type, (JavaType)type.containedTypeOrUnknown(0), (JavaType)type.containedTypeOrUnknown(1));
        }
        if (Lazy.class.isAssignableFrom(raw)) {
            return ReferenceType.upgradeFrom((JavaType)type, (JavaType)type.containedTypeOrUnknown(0));
        }
        if (Option.class.isAssignableFrom(raw)) {
            return ReferenceType.upgradeFrom((JavaType)type, (JavaType)type.containedTypeOrUnknown(0));
        }
        return type;
    }
}

