/*
 * Decompiled with CFR 0.152.
 */
package io.vavr.jackson.datatype.serialize;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.SerializerProvider;
import io.vavr.control.Either;
import io.vavr.jackson.datatype.serialize.HListSerializer;
import java.io.IOException;

class EitherSerializer
extends HListSerializer<Either<?, ?>> {
    private static final long serialVersionUID = 1L;

    EitherSerializer(JavaType type) {
        super(type);
    }

    public void serialize(Either<?, ?> value, JsonGenerator gen, SerializerProvider provider) throws IOException {
        gen.writeStartArray();
        if (value.isLeft()) {
            gen.writeString("left");
            this.write(value.left().get(), 0, gen, provider);
        } else {
            gen.writeString("right");
            this.write(value.right().get(), 1, gen, provider);
        }
        gen.writeEndArray();
    }

    public boolean isEmpty(SerializerProvider provider, Either<?, ?> value) {
        return value.isEmpty();
    }
}

