/*
 * Decompiled with CFR 0.152.
 */
package io.vavr.jackson.datatype.serialize;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;

abstract class HListSerializer<T>
extends StdSerializer<T> {
    private static final long serialVersionUID = 1L;
    private final JavaType type;

    HListSerializer(JavaType type) {
        super(type);
        this.type = type;
    }

    void write(Object val, int containedTypeIndex, JsonGenerator gen, SerializerProvider provider) throws IOException {
        if (val != null) {
            if (this.type.containedTypeCount() > containedTypeIndex) {
                JsonSerializer ser;
                JavaType containedType = this.type.containedType(containedTypeIndex);
                if (containedType != null && containedType.hasGenericTypes()) {
                    JavaType st = provider.constructSpecializedType(containedType, val.getClass());
                    ser = provider.findTypedValueSerializer(st, true, null);
                } else {
                    ser = provider.findTypedValueSerializer(val.getClass(), true, null);
                }
                ser.serialize(val, gen, provider);
            } else {
                gen.writeObject(val);
            }
        } else {
            gen.writeNull();
        }
    }

    public void serializeWithType(T value, JsonGenerator gen, SerializerProvider serializers, TypeSerializer typeSer) throws IOException {
        typeSer.writeTypePrefixForScalar(value, gen);
        this.serialize(value, gen, serializers);
        typeSer.writeTypeSuffixForScalar(value, gen);
    }
}

