/*
 * Decompiled with CFR 0.152.
 */
package io.vavr.jackson.datatype.deserialize;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.deser.ContextualDeserializer;
import com.fasterxml.jackson.databind.jsontype.TypeDeserializer;
import io.vavr.jackson.datatype.deserialize.ValueDeserializer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

abstract class ArrayDeserializer<T>
extends ValueDeserializer<T>
implements ContextualDeserializer {
    private static final long serialVersionUID = 1L;
    protected final JavaType collectionType;
    protected final JavaType elementType;
    protected final TypeDeserializer elementTypeDeserializer;
    protected final JsonDeserializer<?> elementDeserializer;
    protected final boolean deserializeNullAsEmptyCollection;

    ArrayDeserializer(JavaType collectionType, int typeCount, JavaType elementType, TypeDeserializer elementTypeDeserializer, JsonDeserializer<?> elementDeserializer, boolean deserializeNullAsEmptyCollection) {
        super(collectionType, typeCount);
        this.collectionType = collectionType;
        this.elementType = elementType;
        this.elementTypeDeserializer = elementTypeDeserializer;
        this.elementDeserializer = elementDeserializer;
        this.deserializeNullAsEmptyCollection = deserializeNullAsEmptyCollection;
    }

    abstract T create(List<Object> var1, DeserializationContext var2) throws JsonMappingException;

    abstract ArrayDeserializer<T> createDeserializer(TypeDeserializer var1, JsonDeserializer<?> var2);

    public JsonDeserializer<?> createContextual(DeserializationContext ctxt, BeanProperty property) throws JsonMappingException {
        JsonDeserializer elementDeser = this.elementDeserializer;
        TypeDeserializer elementTypeDeser = this.elementTypeDeserializer;
        elementDeser = elementDeser == null ? ctxt.findContextualValueDeserializer(this.elementType, property) : ctxt.handleSecondaryContextualization(elementDeser, property, this.elementType);
        if (elementTypeDeser != null) {
            elementTypeDeser = elementTypeDeser.forProperty(property);
        }
        return this.createDeserializer(elementTypeDeser, elementDeser);
    }

    public T deserialize(JsonParser parser, DeserializationContext context) throws IOException {
        if (!parser.isExpectedStartArrayToken()) {
            throw ArrayDeserializer.mappingException(context, this.collectionType.getRawClass(), parser.getCurrentToken());
        }
        ArrayList<Object> elements = new ArrayList<Object>();
        JsonToken jsonToken = parser.nextToken();
        while (jsonToken != JsonToken.END_ARRAY) {
            Object element = jsonToken == JsonToken.VALUE_NULL ? this.elementDeserializer.getNullValue(context) : (this.elementTypeDeserializer == null ? this.elementDeserializer.deserialize(parser, context) : this.elementDeserializer.deserializeWithType(parser, context, this.elementTypeDeserializer));
            elements.add(element);
            jsonToken = parser.nextToken();
        }
        return this.create(elements, context);
    }

    public T getNullValue(DeserializationContext ctxt) throws JsonMappingException {
        if (this.deserializeNullAsEmptyCollection) {
            return this.create(Collections.emptyList(), ctxt);
        }
        return (T)super.getNullValue(ctxt);
    }

    static void checkContainedTypeIsComparable(DeserializationContext ctxt, JavaType type) throws JsonMappingException {
        Class clz = type.getRawClass();
        if (clz == Object.class || !Comparable.class.isAssignableFrom(clz)) {
            throw ArrayDeserializer.mappingException(ctxt, clz, null);
        }
    }
}

