/*
 * Decompiled with CFR 0.152.
 */
package io.vavr.jackson.datatype.deserialize;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.KeyDeserializer;
import com.fasterxml.jackson.databind.jsontype.TypeDeserializer;
import com.fasterxml.jackson.databind.type.MapLikeType;
import io.vavr.Tuple;
import io.vavr.Tuple2;
import io.vavr.collection.HashMap;
import io.vavr.collection.LinkedHashMap;
import io.vavr.collection.Map;
import io.vavr.collection.SortedMap;
import io.vavr.collection.TreeMap;
import io.vavr.jackson.datatype.deserialize.MaplikeDeserializer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;

class MapDeserializer
extends MaplikeDeserializer<Map<?, ?>> {
    private static final long serialVersionUID = 1L;

    MapDeserializer(MapLikeType mapType, KeyDeserializer keyDeserializer, TypeDeserializer elementTypeDeserializer, JsonDeserializer<?> elementDeserializer) {
        super(mapType, keyDeserializer, elementTypeDeserializer, elementDeserializer);
    }

    MapDeserializer(MapDeserializer origin, KeyDeserializer keyDeserializer, TypeDeserializer elementTypeDeserializer, JsonDeserializer<?> valueDeserializer) {
        super(origin.mapType, keyDeserializer, elementTypeDeserializer, valueDeserializer);
    }

    @Override
    MaplikeDeserializer<Map<?, ?>> createDeserializer(KeyDeserializer keyDeserializer, TypeDeserializer elementTypeDeserializer, JsonDeserializer<?> valueDeserializer) {
        return new MapDeserializer(this, keyDeserializer, elementTypeDeserializer, valueDeserializer);
    }

    public Map<?, ?> deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        ArrayList<Tuple2> result = new ArrayList<Tuple2>();
        while (p.nextToken() != JsonToken.END_OBJECT) {
            String name = p.getCurrentName();
            Object key = this.keyDeserializer.deserializeKey(name, ctxt);
            JsonToken t = p.nextToken();
            Object value = t == JsonToken.VALUE_NULL ? this.elementDeserializer.getNullValue(ctxt) : (this.elementTypeDeserializer == null ? this.elementDeserializer.deserialize(p, ctxt) : this.elementDeserializer.deserializeWithType(p, ctxt, this.elementTypeDeserializer));
            result.add(Tuple.of((Object)key, (Object)value));
        }
        if (SortedMap.class.isAssignableFrom(this.handledType())) {
            return TreeMap.ofEntries((Comparator)this.keyComparator, result);
        }
        if (LinkedHashMap.class.isAssignableFrom(this.handledType())) {
            return LinkedHashMap.ofEntries(result);
        }
        return HashMap.ofEntries(result);
    }
}

