/*
 * Decompiled with CFR 0.152.
 */
package io.vavr.jackson.datatype.deserialize;

import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.jsontype.TypeDeserializer;
import io.vavr.collection.Array;
import io.vavr.collection.IndexedSeq;
import io.vavr.collection.List;
import io.vavr.collection.Queue;
import io.vavr.collection.Seq;
import io.vavr.collection.Stream;
import io.vavr.collection.Vector;
import io.vavr.jackson.datatype.deserialize.ArrayDeserializer;

class SeqDeserializer
extends ArrayDeserializer<Seq<?>> {
    private static final long serialVersionUID = 1L;

    SeqDeserializer(JavaType collectionType, JavaType elementType, TypeDeserializer elementTypeDeserializer, JsonDeserializer<?> elementDeserializer, boolean deserializeNullAsEmptyCollection) {
        super(collectionType, 1, elementType, elementTypeDeserializer, elementDeserializer, deserializeNullAsEmptyCollection);
    }

    private SeqDeserializer(SeqDeserializer origin, TypeDeserializer elementTypeDeserializer, JsonDeserializer<?> elementDeserializer) {
        this(origin.collectionType, origin.elementType, elementTypeDeserializer, elementDeserializer, origin.deserializeNullAsEmptyCollection);
    }

    @Override
    Seq<?> create(java.util.List<Object> result, DeserializationContext ctxt) throws JsonMappingException {
        if (Array.class.isAssignableFrom(this.collectionType.getRawClass())) {
            return Array.ofAll(result);
        }
        if (Queue.class.isAssignableFrom(this.collectionType.getRawClass())) {
            return Queue.ofAll(result);
        }
        if (Stream.class.isAssignableFrom(this.collectionType.getRawClass())) {
            return Stream.ofAll(result);
        }
        if (Vector.class.isAssignableFrom(this.collectionType.getRawClass())) {
            return Vector.ofAll(result);
        }
        if (IndexedSeq.class.isAssignableFrom(this.collectionType.getRawClass())) {
            return Array.ofAll(result);
        }
        return List.ofAll(result);
    }

    SeqDeserializer createDeserializer(TypeDeserializer elementTypeDeserializer, JsonDeserializer<?> elementDeserializer) {
        return new SeqDeserializer(this, elementTypeDeserializer, elementDeserializer);
    }
}

